% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptweedie_series.R
\name{ptweedie_series}
\alias{ptweedie_series}
\alias{ptweedie.series}
\title{Series Evaluation for the Tweedie Distribution Function}
\usage{
ptweedie_series(q, power, mu, phi, verbose = FALSE, details = FALSE)

ptweedie.series(q, power, mu, phi, verbose = FALSE, details = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{power}{the power parameter \eqn{p}{power}.}

\item{mu}{the mean parameter \eqn{\mu}{mu}.}

\item{phi}{the dispersion parameter \eqn{\phi}{phi}.}

\item{verbose}{logical; if \code{TRUE}, displays some internal computation details. The default is \code{FALSE}.}

\item{details}{logical; if \code{TRUE}, returns the value of the distribution function and some details.}
}
\value{
A numeric vector of densities.
}
\description{
Evaluates the distribution function (\acronym{df}) for Tweedie distributions 
with \eqn{1 < p < 2}{1 < p < 2}
using an infinite series, for given values of the dependent variable \code{y}, 
the mean \code{mu}, dispersion \code{phi}, and power parameter \code{power}.
\emph{Not usually called by general users}, but can be in the case of evaluation problems.
}
\note{
The 'exact' values for the inverse Gaussian distribution are not really exact, but evaluated using inverse normal distributions,
for which very good numerical approximation are available in R.
}
\examples{
# Plot a Tweedie distribution function
y <- seq(0.01, 4, length = 50)
Fy <- ptweedie_series(y, power = 1.1, mu = 1, phi = 1)
plot(y, Fy, type = "l", lwd = 2, ylab = "Distribution function")

}
\references{
Dunn, Peter K and Smyth, Gordon K (2005).
Series evaluation of Tweedie exponential dispersion model densities
\emph{Statistics and Computing},
\bold{15}(4). 267--280.
\doi{10.1007/s11222-005-4070-y}
}
\keyword{distribution}
