% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptweedie_inversion.R
\name{ptweedie_inversion}
\alias{ptweedie_inversion}
\alias{ptweedie.inversion}
\title{Fourier Inversion Evaluation for the Tweedie Distribution Function}
\usage{
ptweedie_inversion(q, mu, phi, power, verbose = FALSE, details = FALSE, IGexact = TRUE)

ptweedie.inversion(q, power, mu, phi, verbose, details)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{the mean parameter.}

\item{phi}{the dispersion parameter.}

\item{power}{the power parameter \eqn{p}{power}.}

\item{verbose}{logical; if \code{TRUE}, displays some internal computation details. The default is \code{FALSE}.}

\item{details}{logical; if \code{TRUE}, returns the value of the distribution and some information about the integration. The default is \code{FALSE}.}

\item{IGexact}{logical; if \code{TRUE} (the default), evaluate the inverse Gaussian distribution using the 'exact' values, otherwise uses inversion.}
}
\value{
If \code{details = FALSE}, a numeric vector of the distribution function values; if \code{details = TRUE}, a list containing \code{CDF} (a vector of the values of the distribution function) and \code{regions} (a vector of the number of integration regions used).

For special cases of \eqn{p} (i.e., \eqn{p = 0, 1, 2, 3}), where no inversion is needed, \code{regions} is set to \code{NA} for all values of \code{q}.
For special cases of \code{q} for other values of \eqn{p} (i.e., \eqn{P(Y = 0)}), \code{regions} is set to \code{NA}.
}
\description{
Evaluates the distribution function (\acronym{df}) for Tweedie distributions using Fourier inversion, 
for given values of the dependent variable \code{y}, 
the mean \code{mu}, dispersion \code{phi}, and power parameter \code{power}.
\emph{Not usually called by general users}, but can be in the case of evaluation problems.
}
\note{
The 'exact' values for the inverse Gaussian distribution are not really exact, but evaluated using inverse normal distributions,
for which very good numerical approximation are available in R.
}
\examples{
# Plot a Tweedie distribution function
y <- seq(0.01, 4, length = 50)
Fy <- ptweedie_inversion(y, mu = 1, phi = 1, power = 1.1)
plot(y, Fy, type = "l", lwd = 2, ylab = "Distribution function")

}
\references{
Dunn, P. K. and Smyth, G. K. (2008).
Evaluation of Tweedie exponential dispersion model densities by Fourier inversion.
\emph{Statistics and Computing}, 
\bold{18}, 73--86.
\doi{10.1007/s11222-007-9039-6}
}
\keyword{distribution}
