% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_named_connections}
\alias{extract_named_connections}
\title{Extract \verb{<named-connection>} entries from a TWB}
\usage{
extract_named_connections(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
Tibble with columns like \code{connection_id}, \code{connection_caption},
\code{connection_class}, \code{connection_target}, \code{dbname}, \code{schema}, \code{warehouse},
\code{region}, \code{filename}, and \code{location_named}.
}
\description{
Rich, safe extraction of \verb{<named-connection>} nodes and their \verb{<connection>}
attributes into a tidy tibble.
}
\examples{
# Preferred: read from a tiny '.twb'
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
if (nzchar(twb) && file.exists(twb)) {
xml <- xml2::read_xml(twb)
extract_named_connections(xml)
}

# Alternative: read from a tiny '.twbx'
twbx <- system.file("extdata", "test_for_zip.twbx", package = "twbparser")
if (nzchar(twbx) && file.exists(twbx)) {
members <- twbx_list(twbx)
twb_member <- members$Name[grepl("\\\\.twb$", members$Name)][1]
if (!is.na(twb_member)) {
xml <- xml2::read_xml(utils::unz(twbx, twb_member))
extract_named_connections(xml)
  }
}

}
