% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc.effects.R
\name{desc.effects}
\alias{desc.effects}
\title{Describe the effects}
\usage{
desc.effects(x, ...)
}
\arguments{
\item{x}{An object}

\item{...}{list, optional
Additional arguments.}
}
\value{
{Effects, standard errors and confidence intervals of an object}
}
\description{
Describe the effects, and calculate standard
errors and confidence intervals
}
\examples{
data("tMdat")

## tMdat is small simulated data set included in twangMediation for 
## demonstrating the functions. See ?tMdat for details

fit.es.max <- wgtmed(M ~ w1 + w2 + w3,
                      data = tMdat,
                      a_treatment = "A",
                      y_outcome = "Y",
                      total_effect_wts = tMdat$te.wgt,
                      method = "ps",
                      ps_n.trees=1500,
                      ps_shrinkage=0.01,
                      ps_stop.method=c("es.max")
                      )

desc.effects(fit.es.max)
}
\seealso{
\code{\link{desc.effects.mediation}}, \code{\link{wgtmed}}
}
