## Steven Universe ----

stevenUniverse_palette <- list(
  ## Steven ----
  Steven = c(
    "#FC5C64", ## salmon pink t-shirt
    "#FCCC4C", ## yellow star t-shirt
    "#146C94", ## jeans blue
    "#F5AA9D", ## steven pink
    "#150C08", ## steven hair black
    "#143341", ## steven jeans future blue
    "#5CCCF4", ## light blue t-shirt future
    "#F58DA9"  ## steven future pink jacket
  ),
  ## Garnet ----
  Garnet = c(
    "#0E0723", ## garnet dark navy
    "#C33D7D", ## garnet violet
    "#2C3C8C", ## garnet blue
    "#FC7CF1", ## garnet pink
    "#748494", ## garnet grey
    "#F7AF68", ## garnet visor
    "#C6B7E3", ## garnet lilac
    "#D4F6F1", ## garnet light blue night
    "#000000"  ## black
  ),
  ## Amethyst ----
  Amethyst = c(
    "#C0AED9", ## amethyst light lilac grey
    "#3C3B6C", ## amethyst light navy
    "#AE56DE", ## amethyst light purple
    "#94A4AC", ## amethyst light cobalt grey
    "#8C37E5", ## amethyst darker
    "#000000"  ## black
  ),
  ## Pearl ----
  Pearl = c(
    "#f6b6c2", ## light pink Future
    "#a6a0f2", ## light purple 80s
    #"#9bf3dc", ## light turqoise 80s
    "#FBE7B8", ## pearl tan
    "#6deddd", ## light turqoise Future
    #"#fad4bf", ## pearl tan 80s
    "#3e6992", ## pants blue Future
    #"#f8c8b1", ## pearl tan Future
    "#FCD47C"  ## pale yellow previous gen. outfit
  ),
  ## Rose Quartz ----
  RoseQuartz = c(
    "#E284B3", ## pink
    "#84043C", ## dark violet
    "#AC74C4", ## lilac
    "#F68CEC", ## bright pink
    "#C43CC4", ## bright fuchsia
    "#9B5275", ## brick red
    "#B5DAE3"  ## shield outer light blue
  ),
  ## Peridot ----
  Peridot = c(
    "#053E21", ## peridot darker green
    "#FEFF91", ## peridot lightyellow
    "#92D895", ## peridot light green
    "#74AC64", ## peridot khaki green
    "#CCC42C", ## peridot mustard
    "#92F96A", ## peridot lime green
    "#4C7434"  ## peridot darker khaki green
  ),
  ## Lapis Lazuli ----
  LapisLazuli = c(
    "#0064C3", ## lapis blue
    "#9FEEF0", ## lapis light blue
    "#041859", ## lapis dark navy
    "#4682B4", ## steelblue
    "#00C4FA", ## lapis turqoise
    "#00005B", ## lapis dark navy
    "#000000"  ## black
  ),
  ## Diamonds: White, Yellow, Blue, & Pearl ----
  Diamonds = c(
    "#FFFF00", ## Yellow
    "#CCCC00", ## Dark yellow
    "#00BFFF", ## Light Blue
    "#0000FF", ## Blue
    "#FF1493", ## HOt Pink
    "#FFB6C1", ## Light pink
    "#FFFFFF", ## White
    "#000000", ## Black
    "#D3D3D3" ## Grey
  ),
  ## Jasper ----
  Jasper = c(
    "#2e0f16", ## deep brown
    "#a32a2f", ## light reddish brown
    "#eb9352", ## light orange
    "#f8e3db", ## light beige
    "#91837d", ## light grey
    "#37947e"  ## light turqoise-green
  ),
  ## Topaz ----
  Topaz = c(
    "#f5e848", ## yellow
    "#732c05", ## brown
    "#db870c", ## orange
    "#290404", ## dark brown
    "#909090", ## grey
    "#FFFFFF"  ## white
  ),
  ## Spinel ----
  Spinel = c(
    "#c92d7e", ## violet pink
    "#3c1a2d", ## dark brown-purple
    "#e7a6cd", ## light pink
    "#94043a", ## dark wine
    "#e0bed3", ## beige-pink
    "#FFFFFF"  ## white
  ),
  ## Bismuth ----
  Bismuth = c(
    "#93aaca", ## Bismuth blue
    "#f6b8bd", ## salmon
    "#24dabe", ## turqouise
    "#c95657", ## dark sand-orange
    "#89699c", ## dark purple
    "#71f8d3", ## light turqouise
    "#bf3847", ## light brick
    "#19090f"  ## dark brown
  ),
  ## Ruby ----
  Ruby = c(
    "#D81E4A", ## ruby
    "#332027", ## dark brown
    "#751048", ## violet
    "#000000", ## red
    "#F8DB73", ## visor yellow
    "#F4826A"  ## orange
  ),
  ## Sapphire ----
  Sapphire = c(
    "#007fff", ## arryn blue
    "#7fbfff", ## arryn light blue
    "#001933", ## arryn dark navy
    "#4c4cff", ## arryn purple
    "#ffefb2", ## arryn beige
    "#a89797", ## arryn lightbrown
    "#FFFFFF"  ## white
  ),
  ## Emerald ----
  Emerald = c(
    "#33e059", ## mint green
    "#2cc012", ## green
    "#76facc", ## pop turqouise
    "#4c4cff", ## pep lime green
    "#dcfa5a", ## lime
    "#8ee575", ## grass green
    "#34963c"  ## turqouiuse green
  ),
  ## Nephrite ----
  Nephrite = c(
    "#202e13", ## dark army green
    "#83c874", ## light lime green
    "#35782b", ## army green
    "#0c120b", ## black
    "#3b3616", ## khaki brown
    "#6e7469", ## grey
    "#204519"  ## dark khaki green
  ),
  ## Aquamarine ----
  Aquamarine = c(
    "#7ff9f7", ## aquamarine
    "#0b2483", ## dark blue
    "#0f8cde", ## ocean blue
    "#4c4cff", ## arryn purple
    "#040509", ## black
    "#23b4dc", ## turqouise
    "#3c7084"  ## grey blue
  ),
  ## Padparadscha ----
  Padparadscha = c(
    "#FCB881", ## pad light orange
    "#Fb4B4B", ## pad red orange
    "#FC6444", ## pad orange
    "#FC6C6C", ## pad salmon
    "#D48C5C", ## arryn beige
    "#060505"  ## white
  ),
  ## Rutile ----
  Rutile = c(
    "#a92222", ## rutile red
    "#310f13", ## dark brown
    "#fb5c5b", ## salmon
    "#be7977", ## light brick
    "#9b9a9d"  ## grey
  ),
  ## Rhodonite ----
  Rhodonite = c(
    "#d776b1", ## rhodonite pink
    "#180c1d", ## dark purple
    "#f0e2ef", ## pink beige
    "#7b5584", ## light purple
    "#452b5b", ## deep purple
    "#785069", ## diluted wine
    "#a4527c", ## light redwine
    "#8474ac"  ## light purple blue
  ),
  ## Flourite ----
  Flourite = c(
    "#596be4", ## flourite blue-purple
    "#3fe6f8", ## light turqoise
    "#202841", ## dark navy
    "#957bf9", ## light lilac
    "#bf7cf6", ## light pink
    "#62a7bd", ## damp turqouise
    "#332a91", ## deep purple
    "#1f76af" ## deep turqouise
  ),
  ## Mega Pearl ----
  MegaPearl = c(
    "#df84a8", ## cape pink
    "#f6ffa7", ## sash yellow
    "#f9d078", ## sash orange
    "#ffd1ef", ## light pink
    "#eeb0a1", ## beige
    "#fa7a91", ## hair salmon
    "#faffeb", ## cream
    "#e3edf6", ## light blue collar
    "#FFFFFF" ## white
  ),
  Sugilite = c(
    "#bb55e1", ## light purple
    "#16041f", ## dank purple
    "#7e34d4", ## purple
    "#54157b", ## dark purple
    "#ccccfa", ## lilac
    "#839fe2"  ## blue lilac
  ),
  CrazyLaceAgate = c(
    "#fba475", ## light orange
    "#4c84a3", ## navy light
    "#f46124", ## orange
    "#4dacd9", ## light blue
    "#c2421c", ## dark orange
    "#761445", ## grape
    "#fad457"  ## yellow
  ),
  Sardonyx = c(
    "#f04e6e", ## salmon
    "#22102c", ## dark purple
    "#fbe8d7", ## cream
    "#991c50", ## wine purple
    "#db8282", ## beige pink
    "#f57194", ## pink
    "#644c84", ## light purple lilac
    "#74646c"  ## grey
  ),
  Alexandrite = c(
    "#240e31", ## dark purple
    "#cb6bce", ## pink
    "#468892", ## dark turqoiuse
    "#74f3d3", ## mint
    "#751c6d", ## purple
    "#fdc067", ## light orange
    "#ac9ece", ## lilac
    "#6ec5ab"  ## turquoise green
  ),
  SmokyQuartz = c(
    "#8b7182", ## quartz
    "#665e85", ## deep purple
    "#1b6e9c", ## jeans blue
    "#f95b70", ## light red
    "#ffe43f", ## yellow
    "#9fa4cf"  ## lilac
  ),
  BluebirdAzurite = c(
    "#0b8ef8", ## bluebird
    "#b5d6f5", ## water blue
    "#681a15", ## brown
    "#043cb2", ## deep blue
    "#dc5750"  ## brick orange
  ),
  Sunstone = c(
    "#f6a1ca", ## pink
    "#1a1f2b", ## coal black
    "#eb7746", ## orange
    "#fbdb82", ## yellow
    "#9f272e", ## red
    "#d36b8d", ## dark pink
    "#ec9e58", ## light orange
    "#24719b", ## jeans blue
    "#6a1639"  ## wine
  ),
  Opal = c(
    "#c3f9e9", ## mint
    "#8491be", ## light purple
    "#cc8cbb", ## purple lilac
    "#4685a0", ## turqouise
    "#fbf5a3", ## light yellow
    "#864568", ## purple
    "#d3fec8"  ## lime
  ),
  CrystalGems = c(
    "#FC5C64", ## steven red shirt
    "#0E0723", ## garnet deep purple
    "#FC7CF1", ## pink diamond
    "#6DEDDD", ## pearl turqouise
    "#C0AED9", ## amethyst light purple
    "#146C94", ## steven jeans blue
    "#84043C", ## wine burgundy
    "#FCCC4C", ## steven yellow
    "#AE56DE", ## amethyst lilac
    "#F6B6C2", ## pearl pink
    "#2C3C8C", ## light navy amethyst
    "#000000"  ## black
  )
)

#' @title Gems & Friends of Steven Universe palette
#' @description Steven, Garnet, Amethyst, Pearl, Peridot, Sardonyx, Nephrite, Sugilite, & more!
#' @inheritDotParams ggplot2::discrete_scale
#' @param palette name of palette, Default: "Steven"
#' @param n number of colors
#' @param type discrete or continuous
#' @param reverse reverse order, Default: FALSE
#' @rdname stevenUniverse_pal
#' @export
#' @examples
#' library(scales)
#' show_col(stevenUniverse_pal(palette = "Steven")(5))
#' show_col(stevenUniverse_pal(palette = "Pearl")(5))
#' @importFrom scales manual_pal
#' @importFrom grDevices colorRampPalette

stevenUniverse_pal <- function(palette = "Steven", n,
                         type = c("discrete", "continuous"),
                         reverse = FALSE) {
  stevenUniverse <- stevenUniverse_palette[[palette]]

  if (reverse == TRUE) {
    stevenUniverse <- rev(stevenUniverse)
  }

  if (missing(n)) {
    n <- length(stevenUniverse)
  }

  type <- match.arg(type)

  if (type == "discrete" && n > length(stevenUniverse)) {
    stop(paste0("Palette does not have ", n, " colors, maximum is ", length(stevenUniverse), "!"))
  }

  stevenUniverse <- switch(type,
                     continuous = grDevices::colorRampPalette(stevenUniverse)(n),
                     discrete = stevenUniverse[1:n])

  stevenUniverse <- scales::manual_pal(stevenUniverse)

  return(stevenUniverse)
}

#' @title scale_color_stevenUniverse
#' @rdname stevenUniverse_pal
#' @export
#' @examples
#'
#' library(ggplot2)
#' ggplot(airquality, aes(x = Day, y = Temp,
#'      group = as.factor(Month), color = as.factor(Month))) +
#'      geom_point(size = 2.5) +
#'      scale_color_stevenUniverse(palette = "Steven")
#' @importFrom ggplot2 discrete_scale scale_color_gradientn

scale_color_stevenUniverse <- function(palette = "Steven", n, type = "discrete",
                                 reverse = FALSE, ...) {
  if (type == "discrete") {
    ggplot2::discrete_scale("color", "stevenUniverse",
                            stevenUniverse_pal(palette = palette, n = n, type = type,
                                         reverse = reverse), ...)
  } else { ## needs work...
    ggplot2::scale_color_gradientn(colors = stevenUniverse_pal(palette = palette, n = n, type = type,
                                                         reverse = reverse)(8))
  }
}

#' @title scale_colour_stevenUniverse
#' @rdname stevenUniverse_pal
#' @export
#' @examples
#'
#' ggplot(airquality, aes(x = Day, y = Temp,
#'      group = as.factor(Month), color = as.factor(Month))) +
#'      geom_point(size = 2.5) +
#'      scale_colour_stevenUniverse(palette = "Peridot")
#' @importFrom ggplot2 discrete_scale scale_color_gradientn

scale_colour_stevenUniverse <- scale_color_stevenUniverse

#' @title scale_fill_stevenUniverse
#' @rdname stevenUniverse_pal
#' @export
#' @examples
#'
#' ggplot(mpg, aes(displ)) +
#'      geom_histogram(aes(fill = class), col = "black", size = 0.1) +
#'      scale_fill_stevenUniverse(palette = "LapisLazuli")
#' @importFrom ggplot2 discrete_scale scale_fill_gradientn

scale_fill_stevenUniverse <- function(palette = "Steven", n, type = "discrete",
                                reverse = FALSE, ...) {
  if (type == "discrete") {
    ggplot2::discrete_scale("fill", "stevenUniverse",
                            stevenUniverse_pal(palette = palette, n = n, type = type,
                                         reverse = reverse), ...)
  } else { ## needs work...
    ggplot2::scale_fill_gradientn(colors = stevenUniverse_pal(palette = palette, n = n, type = type,
                                                        reverse = reverse)(8))
  }
}
