% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_rstudio_settings.R
\name{set_rstudio_settings}
\alias{set_rstudio_settings}
\title{Select smart setting for RStudio}
\usage{
set_rstudio_settings(set.binary = TRUE)
}
\arguments{
\item{set.binary}{Logical, set to \code{TRUE}, which indicates whether or not
\code{set_binary_only_in_r_profile()} should be run at the end.}
}
\value{
No return value, called for side effects.
}
\description{
This function changes RStudio settings in order to make learning easier for
new users. These settings are stored in:
~/.config/rstudio/rstudio-prefs.json. The most important changes are
\code{save_workspace} to \code{"never"}, \code{load_workspace} to \code{FALSE}, and
\code{"insert_native_pipe_operator"} to \code{TRUE}. All those changes are good for any
user, new or old.

We also change \code{rmd_viewer_type} to \code{"pane"}, \code{show_hidden_files} to \code{TRUE},
\code{rmd_chunk_output_inline} to \code{FALSE}, \code{source_with_echo} to \code{TRUE}, and
\code{packages_pane_enabled} to \code{FALSE}. These settings make RStudio less
confusing to new users. The \code{rmd_viewer_type} setting is especially useful to
students copy/pasting from the Console/Terminal to a tutorial.

The last two changes are setting both \code{rainbow_parentheses} and
\code{syntax_color_console} to \code{TRUE}. We \emph{think} that these settings make coding
errors less likely.
}
