\name{translate}
\Rdversion{1.1}
\alias{translate}
\title{
Translate neurodevelopmental event timing across species
}
\description{
The function translate predicts the unknown events using the model \emph{species score + event score = ln(post-conceptional day - k)} proposed in (Finlay and Darlington 1995; Clancy et al., 2000). The parameter \emph{k} is estimated from the data by maximizing the correlation between the known and predicted events (Clancy et al., 2000). A
scatter plot of the empirical values and its predicted counterpart is also generated by this function. The adjusted \R^{2} is also shown in the plot.
}
\usage{
pred_vals <- translate(event_data, npsp)
}
\arguments{
  \item{event_data}{A data frame containing the known and unknown neurodevelopmental event timing across species. 
}
  \item{npsp}{Number of non-primate species in \emph{event_data}.
}
}

\value{The known and predicted events along with their 95\% confidence interval are returned in \emph{pred_vals}. 
}
\details{
A sufficient number of known events are necessary to obtain reliable predictions. The structure of \emph{input_vals} should be the same as that of event_data.
}

\references{
Finlay, B.L., & Darlington, R.B. (1995). \emph{Linked regularities in the development and evolution of mammalian brains.} Science, 268,1578-1584.\cr

Clancy, B., Darlington, R.B., & Finlay, B.L. (2000).  \emph{The course of human events:  predicting the timing of primate neural development.} Developmental Science, 3, 57-66.\cr
}



\author{
Radhakrishnan Nagarajan
}

\seealso{\code{\link{event_data}}}

\examples{
library(ttime);
data(event_data); #event timing data
npsp <- 8;        #number of non-primate species (npsp) in event_data
pred_vals <- translate(event_data, npsp); #predicted events with 95\% confidence interval
}
