% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsvreq_methods.R
\name{tsvreq_methods}
\alias{tsvreq_methods}
\alias{summary.tsvreq}
\alias{print.tsvreq}
\alias{plot.tsvreq}
\alias{set_ts.tsvreq}
\alias{set_com.tsvreq}
\alias{set_comnull.tsvreq}
\alias{set_tsvr.tsvreq}
\alias{set_wts.tsvreq}
\alias{get_ts.tsvreq}
\alias{get_com.tsvreq}
\alias{get_comnull.tsvreq}
\alias{get_tsvr.tsvreq}
\alias{get_wts.tsvreq}
\title{Basic methods for the \code{tsvreq} class}
\usage{
\method{summary}{tsvreq}(object, ...)

\method{print}{tsvreq}(x, ...)

\method{plot}{tsvreq}(x, filename = NA, ...)

\method{set_ts}{tsvreq}(obj, newval)

\method{set_com}{tsvreq}(obj, newval)

\method{set_comnull}{tsvreq}(obj, newval)

\method{set_tsvr}{tsvreq}(obj, newval)

\method{set_wts}{tsvreq}(obj, newval)

\method{get_ts}{tsvreq}(obj)

\method{get_com}{tsvreq}(obj)

\method{get_comnull}{tsvreq}(obj)

\method{get_tsvr}{tsvreq}(obj)

\method{get_wts}{tsvreq}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{tsvreq}}

\item{...}{Passed to plot. Not currently used for other methods, included there only for argument consistency
with existing generics.}

\item{filename}{A filename, no extension, could have a path. Used for saving a plot as a pdf. The default value NA causes the default plotting device to be used.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.tsvreq} produces a summary of a \code{tsvreq} object.
Methods \code{print.tsvreq} and \code{plot.tsvreq} are also available. For \code{tsvreq} objects, 
\code{set_*} and \code{get_*} methods are available for all slots (see
the documentation for \code{tsvreq} for a list). The \code{set_*} methods 
just throw an error, to prevent breaking the consistency between the 
slots of a \code{tsvreq} object.
}
\description{
Set, get, summary, print and plot methods for the \code{tsvreq} class.
}
\examples{
res<-tsvreq(ts=1:10,com=2*c(1:10),comnull=1:10,tsvr=rep(2,10),wts=rep(3,10))
get_ts(res)
print(res)
summary(res)
plot(res)
 
}
\seealso{
\code{\link{tsvreq}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
