% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_random_ts.R
\name{generate_random_ts}
\alias{generate_random_ts}
\title{Generate a list of random time series}
\usage{
generate_random_ts(n = 1, lengths = 36, starts = 1988, frequencies = 12,
  ranges_min = -1, ranges_max = 1, shifts = 0,
  ts_names = sprintf("ts\%d", 1:n), seed = 30042018, random_NAs = FALSE,
  random_NA_proportions = 0.1, normally_distributed = FALSE,
  normal_means = 0, normal_sds = 1, frequency_shifts = FALSE,
  frequency_shift_after = 0.5)
}
\arguments{
\item{n}{The number of ts objects to generate}

\item{lengths}{The lengths of the time series}

\item{starts}{The start points of the time series in single number notation (e.g. 1990.5)}

\item{frequencies}{The frequencies of the time series}

\item{ranges_min}{The minimum values of the time series (if normally_distributed == FALSE)}

\item{ranges_max}{The maximum values of the time series (if normally_distributed == FALSE)}

\item{shifts}{The shifts of time series values per series}

\item{ts_names}{The names of the ts objects in the resulting list}

\item{seed}{The random seed to be used}

\item{random_NAs}{Whether or not to introcude NA values at random positions in the ts}

\item{random_NA_proportions}{The fraction of values to be replaced with NAs if random_NAs is TRUE for the series}

\item{normally_distributed}{Use normal distribution instead of uniform}

\item{normal_means}{The means to use for normal distribution. Ignored unless normally_distributed is set to TRUE.}

\item{normal_sds}{The sds to use for normal distribution. Ignored unless normally_distributed is set to TRUE.}

\item{frequency_shifts}{Introduce frequency shifts (from 4 to 12) in the ts}

\item{frequency_shift_after}{After what fraction of the ts to shift frequencies}
}
\value{
A list of ts objects
}
\description{
Useful for development or generating easily reproducible examples
}
\details{
Except for n and ts_names, all parameters accept either a single value or a vector of values. If a single value is
supplied, that value is used for all time series being generated. If a vector is supplied, its values
will be used for the corresponding series (e.g. starts[1] is used for the first series, starts[2] for
the second and so on). Vectors are recycled if n is larger than their length.

If a ts_names vector is supplied, it must have length n and must not contain duplicates.
}
\examples{
generate_random_ts()

generate_random_ts(n = 3, ranges_min = c(-10, 0, 10), ranges_max = 20, starts = 2011)
}
