% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_monthly.R
\name{sim_monthly}
\alias{sim_monthly}
\title{Simulate a monthly seasonal series}
\usage{
sim_monthly(
  N,
  sd = 1,
  beta_1 = 0.9,
  change_sd = 0.025,
  model = list(order = c(3, 1, 1), ma = 0.5, ar = c(0.2, -0.4, 0.1)),
  start = c(2010, 1),
  multiplicative = TRUE,
  extra_smooth = FALSE
)
}
\arguments{
\item{N}{Length in years}

\item{sd}{Standard deviation for all seasonal factors}

\item{beta_1}{Persistance wrt to previous period of the seasonal change}

\item{change_sd}{Standard deviation of simulated change for all seasonal factors}

\item{model}{Model for non-seasonal time series. A list.}

\item{start}{Start date of output time series}

\item{multiplicative}{Boolean. Should multiplicative seasonal factors be simulated}

\item{extra_smooth}{Boolean. Should the seasonal factors be smooth on a period-by-period basis}
}
\value{
Multiple simulated monthly time series of class xts including:
\describe{
\item{original}{The original series}
\item{seas_adj}{The original series without seasonal effects}
\item{sfac}{The seasonal effect}
}
}
\description{
Simulate a monthly seasonal series
}
\details{
Standard deviation of the seasonal factor is in percent if a multiplicative time series model is assumed. Otherwise it is in unitless.
Using a non-seasonal ARIMA model for the initialization of the seasonal factor does not impact the seasonality of the time series. It can just make it easier for human eyes to grasp the seasonal nature of the series. The definition of the ar and ma parameter needs to be inline with the chosen model.
}
\examples{
x=sim_monthly(5, multiplicative=TRUE)
ts.plot(x[,1])
}
\references{
Ollech, D. (2021). Seasonal adjustment of daily time series. Journal of Time Series Econometrics. \doi{10.1515/jtse-2020-0028}
}
\author{
Daniel Ollech
}
