% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salient.R
\name{salient_subsequences}
\alias{salient_subsequences}
\title{Framework for retrieve salient subsequences from a dataset}
\usage{
salient_subsequences(.mp, data, n_bits = 8, n_cand = 10,
  exclusion_zone = NULL, verbose = 2)
}
\arguments{
\item{.mp}{a TSMP object of class \code{MatrixProfile}.}

\item{data}{the data used to build the Matrix Profile, if not embedded.}

\item{n_bits}{an \code{int} or \code{vector} of \code{int}. Number of bits for MDL discretization. (Default is \code{8}).}

\item{n_cand}{an \code{int}. number of candidate when picking the subsequence in each iteration.
(Default is \code{10}).}

\item{exclusion_zone}{if a \code{number} will be used instead of embedded value. (Default is \code{NULL}).}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}
}
\value{
Returns the input \code{.mp} object with a new name \code{salient}. It contains: \code{indexes}, a \code{vector}
with the starting position of each subsequence, \code{idx_bit_size}, a \code{vector} with the associated
bitsize for each iteration and \code{bits} the value used as input on \code{n_bits}.
}
\description{
In order to allow a meaningful visualization in Multi-Dimensional Space (MDS), this function
retrieves the most relevant subsequences using Minimal Description Length (MDL) framework.
}
\details{
\code{verbose} changes how much information is printed by this function; \code{0} means nothing,
\code{1} means text, \code{2} adds the progress bar, \code{3} adds the finish sound.
}
\examples{
# toy example
data <- mp_toy_data$data[, 1]
mp <- tsmp(data, window_size = 30, verbose = 0)
mps <- salient_subsequences(mp, data, verbose = 0)

\dontrun{
# full example
data <- mp_meat_data$sub$data
w <- mp_meat_data$sub$sub_len
mp <- tsmp(data, window_size = w, verbose = 2, n_workers = 6)
mps <- salient_subsequences(mp, data, n_bits = c(4, 6, 8), verbose = 2)
}

}
\references{
\itemize{
\item Yeh CCM, Van Herle H, Keogh E. Matrix profile III: The matrix profile allows
visualization of salient subsequences in massive time series. Proc - IEEE Int Conf Data Mining,
ICDM. 2017;579–88.
}

\itemize{
\item Hu B, Rakthanmanon T, Hao Y, Evans S, Lonardi S, Keogh E. Discovering the Intrinsic
Cardinality and Dimensionality of Time Series Using MDL. In: 2011 IEEE 11th International
Conference on Data Mining. IEEE; 2011. p. 1086–91.
}

Website: \url{https://sites.google.com/site/salientsubs/}
}
