% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{new_interval}
\alias{new_interval}
\alias{is_regular_interval}
\alias{gcd_interval}
\title{Interval constructor for a tsibble}
\usage{
new_interval(..., .regular = TRUE, .others = list())

is_regular_interval(x)

gcd_interval(x)
}
\arguments{
\item{...}{A set of name-value pairs to specify default interval units: "year",
"quarter", "month", "week", "day", "hour", "minute", "second", "millisecond",
"microsecond", "nanosecond", "unit".}

\item{.regular}{Logical. \code{FALSE} gives an irregular interval, and will ignore
the \code{...} argument.}

\item{.others}{A list name-value pairs that are not included in the \code{...},
to allow custom interval.}

\item{x}{An interval.}
}
\value{
an "interval" class
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\itemize{
\item \code{new_interval()} creates an interval object.
\item \code{gcd_interval()} computes the greatest common divisor for the difference
of numerics.
\item \code{is_regular_interval()} checks if the interval is regular.
}
}
\examples{
(x <- new_interval(hour = 1, minute = 30))
(y <- new_interval(.regular = FALSE)) # irregular interval
new_interval() # unknown interval
new_interval(.others = list(semester = 1)) # custom interval
is_regular_interval(x)
is_regular_interval(y)
gcd_interval(c(1, 3, 5, 6))
}
