% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_crosstab.R
\name{generate_crosstab}
\alias{generate_crosstab}
\title{Generate cross-tabulation}
\usage{
generate_crosstab(
  data,
  x,
  ...,
  add_total = TRUE,
  add_total_row = TRUE,
  add_total_column = TRUE,
  add_percent = TRUE,
  as_proportion = FALSE,
  percent_by_column = FALSE,
  name_separator = "_",
  label_separator = "__",
  label_total = "Total",
  label_total_column = NULL,
  label_total_row = NULL,
  label_na = "Not reported",
  include_na = TRUE,
  recode_na = "auto",
  label_as_group_name = TRUE,
  group_separator = " - ",
  group_as_list = FALSE,
  group_grand_total = FALSE,
  group_grand_total_label = "All",
  calculate_per_group = TRUE,
  expand_categories = TRUE,
  position_total = "bottom",
  sort_column_names = TRUE,
  collapse_list = FALSE,
  convert_factor = FALSE,
  metadata = NULL
)
}
\arguments{
\item{data}{A data frame (typically \code{tibble}) containing the variables to summarize.}

\item{x}{The variable to use for the rows of the cross-tabulation.}

\item{...}{Additional variable(s) to use for the columns of the cross-tabulation. If none are provided, a frequency table for \code{x} will be returned.}

\item{add_total}{Logical. If \code{TRUE}, adds total row and/or column.}

\item{add_total_row}{Logical. If \code{TRUE}, adds a total row.}

\item{add_total_column}{Logical. If \code{TRUE}, adds a total column.}

\item{add_percent}{Logical. If \code{TRUE}, adds percent or proportion values to the table.}

\item{as_proportion}{Logical. If \code{TRUE}, displays proportions instead of percentages (range 0–1).}

\item{percent_by_column}{Logical. If \code{TRUE}, percentages are calculated by column; otherwise, by row.}

\item{name_separator}{Character. Separator used when constructing variable names in the output.}

\item{label_separator}{Character. Separator used when constructing labels in the output.}

\item{label_total}{Character. Label used for the total row/category.}

\item{label_total_column}{Character. Label used for the total column/category.}

\item{label_total_row}{Character. Label used for the total row/category.}

\item{label_na}{Character. Label to use for missing (\code{NA}) values.}

\item{include_na}{Logical. If \code{TRUE}, includes missing values in the cross table.}

\item{recode_na}{Character or \code{NULL}. Value used to replace missing values in labelled vectors; \code{"auto"} will determine a code automatically.}

\item{label_as_group_name}{Logical. If \code{TRUE}, uses the variable label of the grouping variable(s) as the name in the output list.}

\item{group_separator}{Character. Separator used when constructing group names in the output list.}

\item{group_as_list}{Logical. If \code{TRUE}, the output will be a list of data frames, one for each combination of grouping variable(s).}

\item{group_grand_total}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. Compute grand total based on the grouping variable.}

\item{group_grand_total_label}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Character. Apply label to the grand total if \code{group_grand_total} is set to \code{TRUE}.}

\item{calculate_per_group}{Logical. If \code{TRUE}, calculates the cross-tabulation separately for each group defined by the grouping variable(s).}

\item{expand_categories}{Logical. If \code{TRUE}, ensures that all categories of \code{x} are represented in the output, even if they have zero counts.}

\item{position_total}{Character. Position of the total row/column; either \code{"bottom"} or \code{"top"} for rows, and \code{"right"} or \code{"left"} for columns.}

\item{sort_column_names}{Logical. If \code{TRUE}, sorts the column names in the output.}

\item{collapse_list}{Logical (NOT YET IMPLEMENTED). If \code{TRUE} and \code{group_as_list = TRUE}, collapses the list of frequency tables into a single data frame with group identifiers. See also \code{\link[=collapse_list]{collapse_list()}}.}

\item{convert_factor}{Logical. If \code{TRUE}, converts labelled variables to factors in the output. See also \code{\link[=convert_factor]{convert_factor()}}.}

\item{metadata}{A named list with optional metadata to attach as attributes, e.g. \code{title}, \code{subtitle}, and \code{source_note}.}
}
\value{
A data frame or a list of data frames containing the cross-tabulation results. If \code{group_as_list} is \code{TRUE}, the output will be a list of data frames, one for each combination of grouping variable(s). Otherwise, a single data frame is returned. Each data frame includes counts and, if specified, percentages or proportions for each combination of \code{x} and the additional variables provided in \code{...}.
}
\description{
Generate cross-tabulation
}
\examples{
# Using built-in dataset `person_record`

# Basic usage
person_record |>
 generate_crosstab(marital_status, sex)


# Multiple variables
person_record |>
 generate_crosstab(
  sex,
  seeing,
  hearing,
  walking,
  remembering,
  self_caring,
  communicating
 )

 # Grouping
 person_record |>
   dplyr::group_by(sex) |>
   generate_crosstab(marital_status, employed, group_as_list = TRUE)

# # Percent or proportion by row or column
person_record |>
 generate_crosstab(
   marital_status,
   sex,
   percent_by_column = TRUE
 )
}
\seealso{
\code{\link[=generate_frequency]{generate_frequency()}}, \code{\link[=generate_output]{generate_output()}}, \code{\link[=rename_label]{rename_label()}}, \code{\link[=remove_label]{remove_label()}}
}
