% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_vtscopula.R
\name{fit,vtscopula-method}
\alias{fit,vtscopula-method}
\title{Fit method for vtscopula class}
\usage{
\S4method{fit}{vtscopula}(
  x,
  y,
  tsoptions = list(),
  control = list(maxit = 2000, warn.1d.NelderMead = FALSE)
)
}
\arguments{
\item{x}{an object of class \linkS4class{vtscopula}.}

\item{y}{a vector or time series of data.}

\item{tsoptions}{list of optional arguments:
hessian is logical variable specifying whether Hessian matrix should be returned;
method is choice of optimization method.}

\item{control}{list of control parameters to be passed to the
\code{\link[stats]{optim}} function.}
}
\value{
An object of class \linkS4class{tscopulafit}.
}
\description{
Fit object of class \linkS4class{vtscopula}
to data using maximum likelihood.
}
\examples{
copobject <- armacopula(pars = list(ar = 0.6, ma = 0.2))
vtcop <- vtscopula(copobject, Vtransform = V2p())
y <- sim(vtcop)
fit(vtcop, y)
}
