% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_regular.R
\name{ts_regular}
\alias{ts_regular}
\title{Enforce Regularity}
\usage{
ts_regular(x)
}
\arguments{
\item{x}{a ts-boxable time series}
}
\description{
Enforces regularity in data frame and \code{xts} objects, by turning implicit
\code{NA}s into explicit \code{NA}s. In \code{ts} objects, regularity is automatically
enforced.
}
\examples{
x0 <- AirPassengers
x0[c(10, 15)] <- NA
x <- ts_na_omit(ts_dts(x0))
ts_regular(x)

m <- mdeaths
m[c(10, 69)] <- NA
f <- fdeaths
f[c(1, 3, 15)] <- NA

ts_regular(ts_na_omit(ts_dts(ts_c(f, m))))
}
