% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_pick.R
\name{ts_pick}
\alias{ts_pick}
\title{Pick Series (Experimental)}
\usage{
ts_pick(x, ...)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, or \code{timeSeries}.}

\item{...}{character string(s), names of the series to be picked. If arguments are named, the series will be renamed.}
}
\value{
a ts-boxable time series, with the same class as the input.
}
\description{
Pick (and optionally rename) series from multiple time series.
}
\examples{
# Interactive use
\donttest{
ts_plot(ts_pick(
  EuStockMarkets, 
  `My Dax` = "DAX", 
  `My Smi` = "SMI"
))
head(ts_pick(EuStockMarkets, c(1, 2)))
head(ts_pick(EuStockMarkets, `My Dax` = 'DAX', `My Smi` = 'SMI'))
}

# Programming use
to.be.picked.and.renamed <- c(`My Dax` = "DAX", `My Smi` = "SMI")
head(ts_pick(EuStockMarkets, to.be.picked.and.renamed))
}
