% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp.r
\name{simpledecomp}
\alias{simpledecomp}
\title{\code{simpledecomp} decomposes a vector into trend, season and irregular component
by linear regression approach}
\usage{
simpledecomp(y, trend = 0, season = 0, Plot = FALSE)
}
\arguments{
\item{y}{the series, a vector or a time series}

\item{trend}{order of trend polynomial}

\item{season}{period of seasonal component}

\item{Plot}{logical, should a plot be produced?}
}
\value{
out:  (n,3) matrix
\item{1. column}{smooth component }
\item{2. column}{seasonal component }
\item{3. column}{irregular component  }
}
\description{
\code{simpledecomp} decomposes a vector into trend, season and irregular component
by linear regression approach
}
\examples{
data(GDP)
out  <- simpledecomp(GDP,trend=3,season=4,Plot=FALSE) 
}
