% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regime.R
\name{regime}
\alias{regime}
\alias{regime.default}
\alias{regime.lstar}
\title{Extract a variable showing the regime}
\usage{
regime(object, initVal = TRUE, timeAttr = TRUE, series = NULL, ...)

\method{regime}{lstar}(object, initVal = TRUE, timeAttr = TRUE, series, discretize = TRUE, ...)
}
\arguments{
\item{object}{object of class \code{setar} or \code{nlVar}}

\item{initVal}{Logical. Whether the NA initial values should be returned.
Default to TRUE.}

\item{timeAttr}{Logical. Whether the time attributes should be returned.
Default to TRUE.}

\item{series}{Optional. A numeric vector to classify according to the model.}

\item{\dots}{additional arguments to \code{regime}}

\item{discretize}{logical (default TRUE) whether the series are discretized to \{1,2\}, 
or whether regime probabilities are returned.}
}
\value{
Time series of same attributes as input to setar.
}
\description{
This function allows to extract the indicator variable specifying the regime
in which the process is at time t.
}
\examples{

set<-setar(lynx, m=3)
regime(set)
regime(set, time=FALSE, initVal=FALSE)

plot(regime(set))

}
\author{
Matthieu Stigler
}
\keyword{ts}
