% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar_mean.R
\name{charac_root}
\alias{charac_root}
\alias{charac_root.nlar}
\title{Characteristic roots of the AR coefficients}
\usage{
charac_root(object, ...)

\method{charac_root}{nlar}(object, ...)
}
\arguments{
\item{object}{object of class \code{\link{nlar}}}

\item{\ldots}{currently unused}
}
\value{
a data.frame, with the modulus of the roots. 
For models with multiple regimes (setar, lstar, star), one column per regime.
}
\description{
Computes the (inverse) characteristic roots of the auto-regressive coefficients. 
To be stationary, the values should be outside the unit circle. The function here returns the
modulus of the roots.
}
\details{
Computes the roots of the polynomial (1, -phi) using function \code{\link{polyroot}}
}
\examples{
mod.ar <-  linear(lh, m = 5, include = "const")
mod.setar <-  setar(lh, m = 5, include = "const")

charac_root(mod.ar)
charac_root(mod.setar)
}
