% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dist_file_parts_merge}
\alias{dist_file_parts_merge}
\title{Merge parts of distances stored in files.}
\usage{
dist_file_parts_merge(list_files, dir_path, num_elements, file_type = "RDS")
}
\arguments{
\item{list_files}{A list of files with distances.}

\item{dir_path}{If list_files was not passed, than this function uses this parameter
to read the files in this directory.}

\item{num_elements}{The number of time series in the data set. The number of elements
defines the number of rows ans columns in the distance matrix D.}

\item{file_type}{The extension of the files where the distances are stored. It can be
"RDS" (default) or "csv". The RDS files should be data frames composed by three
columns i,j, and dist. This format is preferred because it is a compact file. The other
option is a "csv" also containing the i,j, and dist columns.}
}
\value{
Distance matrix D
}
\description{
The functions tsdist_dir_parallel and tsdist_parts_parallel calculate part of
the distance matrix D. The results of the multiple calls of these functions are
normally stored in RDS or csv files. This function merges these files and construct
a distance matrix D.
}
