% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_phregr.R
\name{residuals_phregr}
\alias{residuals_phregr}
\title{Residuals for Proportional Hazards Regression Models}
\usage{
residuals_phregr(
  object,
  type = c("martingale", "deviance", "score", "schoenfeld", "dfbeta", "dfbetas",
    "scaledsch"),
  collapse = FALSE,
  weighted = (type \%in\% c("dfbeta", "dfbetas"))
)
}
\arguments{
\item{object}{The output from the \code{phregr} call.}

\item{type}{The type of residuals desired, with options including
\code{"martingale"}, \code{"deviance"}, \code{"score"},
\code{"schoenfeld"}, \code{"dfbeta"}, \code{"dfbetas"}, and
\code{"scaledsch"}.}

\item{collapse}{Whether to collapse the residuals by \code{id}.
This is not applicable for Schoenfeld type residuals.}

\item{weighted}{Whether to compute weighted residuals.}
}
\value{
For martingale and deviance residuals, the result is a vector
with one element corresponding to each subject (without \code{collapse}).
For score residuals, the result is a matrix where each row represents
a subject and each column corresponds to a variable. The row order
aligns with the input data used in the original fit. For Schoenfeld
residuals, the result is a matrix with one row for each event and
one column per variable. These rows are sorted by time within strata,
with the attributes \code{stratum} and \code{time} included.

Score residuals represent each individual's contribution to the score
vector. Two commonly used transformations of this are \code{dfbeta},
which represents the approximate change in the coefficient vector
if the observation is excluded, and \code{dfbetas}, which gives the
approximate change in the coefficients scaled by the standard error
of the coefficients.
}
\description{
Obtains the martingale, deviance, score, or Schoenfeld
residuals for a proportional hazards regression model.
}
\details{
For score and Schoenfeld type residuals, the proportional hazards model
must include at least one covariate. The algorithms for \code{deviance},
\code{dfbeta}, \code{dfbetas}, and \code{scaledsch} residuals follow
the \code{residuals.coxph} function in the \code{survival} package.
}
\examples{

library(dplyr)

# Example 1 with right-censored data
fit1 <- phregr(data = rawdata \%>\% filter(iterationNumber == 1) \%>\%
                 mutate(treat = 1*(treatmentGroup == 1)),
               stratum = "stratum",
               time = "timeUnderObservation", event = "event",
               covariates = "treat")

ressco <- residuals_phregr(fit1, type = "score")

# Example 2 with counting process data
fit2 <- phregr(data = heart \%>\% mutate(rx = as.numeric(transplant) - 1),
               time = "start", time2 = "stop", event = "event",
               covariates = c("rx", "age"), id = "id", robust = TRUE)

resssch <- residuals_phregr(fit2, type = "scaledsch")

}
\references{
Terry M. Therneau, Patricia M. Grambsch, and Thomas M. Fleming.
Martingale based residuals for survival models.
Biometrika 1990; 77:147-160.

Patricia M. Grambsch and Terry M. Therneau.
Proportional hazards tests and diagnostics based on weighted residuals.
Biometrika 1994; 81:515-26.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
