% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qrcpp}
\alias{qrcpp}
\title{QR Decomposition of a Matrix}
\usage{
qrcpp(x, tol = 1e-12)
}
\arguments{
\item{x}{A numeric matrix whose QR decomposition is to be computed.}

\item{tol}{The tolerance for detecting linear dependencies in the
columns of \code{x}.}
}
\value{
A list with the following components:
\itemize{
\item \code{qr}: A matrix with the same dimensions as \code{x}. The upper
triangle contains the \code{R} of the decomposition and the lower
triangle contains Householder vectors (stored in compact form).
\item \code{rank}: The rank of \code{x} as computed by the decomposition.
\item \code{pivot}: The column permutation for the pivoting strategy used
during the decomposition.
\item \code{Q}: The complete \eqn{m}-by-\eqn{m} orthogonal matrix \eqn{Q}.
\item \code{R}: The complete \eqn{m}-by-\eqn{n} upper triangular
matrix \eqn{R}.
}
}
\description{
Computes the QR decomposition of a matrix.
}
\details{
This function performs Householder QR with column pivoting:
Given an \eqn{m}-by-\eqn{n} matrix \eqn{A} with \eqn{m \geq n},
the following algorithm computes \eqn{r = \textrm{rank}(A)} and
the factorization \eqn{Q^T A P} equal to
\tabular{ccccc}{
| \tab \eqn{R_{11}} \tab \eqn{R_{12}} \tab | \tab \eqn{r} \cr
| \tab 0 \tab 0 \tab | \tab \eqn{m-r} \cr
\tab \eqn{r} \tab \eqn{n-r} \tab \tab
}
with \eqn{Q = H_1 \cdots H_r} and \eqn{P = P_1 \cdots P_r}.
The upper triangular part of \eqn{A}
is overwritten by the upper triangular part of \eqn{R} and
components \eqn{(j+1):m} of
the \eqn{j}th Householder vector are stored in \eqn{A((j+1):m, j)}.
The permutation \eqn{P} is encoded in an integer vector \code{pivot}.
}
\examples{

hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, `+`) }
h9 <- hilbert(9)
qrcpp(h9)

}
\references{
Gene N. Golub and Charles F. Van Loan.
Matrix Computations, second edition. Baltimore, Maryland:
The John Hopkins University Press, 1989, p.235.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
