% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_matches.R
\name{boxplot_matches}
\alias{boxplot_matches}
\title{Series of boxplots for a given variable characterizing the triples match}
\usage{
boxplot_matches(m, y, z, yname = NULL)
}
\arguments{
\item{m}{`m` element of the list returned from `triples()` function containing information
about matched individuals}

\item{y}{Named vector containing variable to plot on the y axis.
Names must correspond to the units specified in `m`}

\item{z}{Vector of treatment indicators. Must be in same order as `y`}

\item{yname}{y axis label}
}
\value{
Display containing three sets of boxplots for the propensity score.
    First is for all treated vs control units.
    Second is for the triples that have one treated unit and two controls.
    Third is for the triples that have two treated units and one control.
}
\description{
Series of boxplots for a given variable characterizing the triples match
}
\examples{
# Generate some data
set.seed(8)
n <- 200
nt <- floor(n * 0.5)
nc <- n - nt
x <- c(rnorm(nt, 0, 1), rnorm(nc, 0.6, 1))
z <- c(rep(1, nt), rep(0, nc))
# Create some strata
ps <- glm(z ~ x, family = binomial)$fitted.values
ps_st <- cut(ps, c(0, quantile(ps, 1/3 * 1:2), 1), labels = 1:3)
# Create a distance matrix
dist <- dist_mahal(data.frame(x = x), z, ps_st)
# Construct the triples match
triplesm <- triples(cost = dist, z = z, st = ps_st, solver = "rlemon")
boxplot_matches(m = triplesm$m, y = ps, z = z, yname = "Propensity score")
}
