% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_diffs.R
\name{boxplot_diffs}
\alias{boxplot_diffs}
\title{Boxplots of pairwise differences in triples match}
\usage{
boxplot_diffs(m, y, z, yname = NULL)
}
\arguments{
\item{m}{`m` element of the list returned from `triples()` function containing information
about matched individuals}

\item{y}{Named vector containing variable to plot on the y axis.
Names must correspond to the units specified in `m`}

\item{z}{Vector of treatment indicators. Must be in same order as `y`}

\item{yname}{y axis label}
}
\value{
Boxplots with treated minus control pair differences for the specified covariate.
    Boxplots are show for before matching, for the matches with 1 treated individual,
    for the matches with 2 treated individuals, and for the weighted combination that
    duplicates the differences for the matches with two treated individuals
}
\description{
Make boxplots of treated - control pair differences before matching, for the two types of triples, and weighted across triples
}
\examples{
# Generate some data
set.seed(8)
n <- 200
nt <- floor(n * 0.5)
nc <- n - nt
x <- c(rnorm(nt, 0, 1), rnorm(nc, 0.6, 1))
z <- c(rep(1, nt), rep(0, nc))
# Create some strata
ps <- glm(z ~ x, family = binomial)$fitted.values
ps_st <- cut(ps, c(0, quantile(ps, 1/3 * 1:2), 1), labels = 1:3)
# Create a distance matrix
dist <- dist_mahal(data.frame(x = x), z, ps_st)
# Construct the triples match
triplesm <- triples(cost = dist, z = z, st = ps_st, solver = "rlemon")
boxplot_diffs(m = triplesm$m, y = ps, z = z, yname = "Propensity score")
}
