% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trip.R
\name{trackDistance}
\alias{trackDistance}
\alias{trackDistance.default}
\alias{trackDistance.trip}
\title{Determine distances along a track}
\usage{
trackDistance(x1, y1, x2, y2, longlat = TRUE, prev = FALSE)
}
\arguments{
\item{x1}{trip object, matrix of 2-columns, with x/y coordinates OR a vector
of x start coordinates}

\item{y1}{vector of y start coordinates, if x1 is not a matrix}

\item{x2}{vector of x end coordinates, if x1 is not a matrix}

\item{y2}{vector of y end coordinates, if x1 is not a matrix}

\item{longlat}{if FALSE, Euclidean distance, if TRUE Great Circle distance}

\item{prev}{if TRUE and x1 is a trip, the return value has a padded end
value (\"prev\"ious), rather than start (\"next\")}
}
\value{
Vector of distances between coordinates.
}
\description{
Calculate the distances between subsequent 2-D coordinates using Euclidean
or Great Circle distance (WGS84 ellipsoid) methods.
}
\details{
If \code{x1} is a trip object, arguments \code{x2}, \code{x3}, \code{y2} are
ignored and the return result has an extra element for the start point of
each individual trip, with value 0.0.

The \code{prev} argument is ignore unless x1 is a trip.

Distance values are in the units of the input coordinate system when longlat
is FALSE, and in kilometres when longlat is TRUE.

This originally used \code{\link[sp]{spDistsN1}} but now implements the sp
\code{gcdist} source directly in R.
}
\examples{
## Continuing the example from '?"trip-methods"':
utils::example("trip-methods", package="trip",
               ask=FALSE, echo=FALSE)

 ## the method knows this is a trip, so there is a distance for every
 ## point, including 0s as the start and at transitions between
 ## individual trips
trackDistance(tr)

## the default method does not know about the trips, so this is
##(n-1) distances between all points
## trackDistance(coordinates(tr), longlat = FALSE)

## we get NA at the start, end and at transitions between trips

 \dontrun{
 require(rgdal)
 trackAngle(tr)
 }
}
\author{
Roger Bivand and Michael Sumner
}
\references{
Original source taken from sp package.
}

