% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smk.test.R
\name{smk.test}
\alias{smk.test}
\alias{Hirsch-Slack-Test}
\title{Seasonal Mann-Kendall Trend Test}
\usage{
smk.test(x, alternative = c("two.sided", "greater", "less"),
  continuity = TRUE)
}
\arguments{
\item{x}{a time series object with class \code{ts} comprising >= 2 seasons;
\code{NA} values are not allowed}

\item{alternative}{the alternative hypothesis, defaults to \code{two.sided}}

\item{continuity}{logical, indicates, whether a continuity correction
should be done; defaults to \code{TRUE}}
}
\value{
An object with class "htest" and "smktest"
\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value for the entire series}
\item{statistic}{the z quantile of the standard normal distribution
for the entire series}
\item{null.value}{the null hypothesis}
\item{estimates}{the estimates S and varS for the entire series}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
\item{Sg}{numeric vector that contains S scores for each season}
\item{varSg}{numeric vector that contains varS for each season}
\item{pvalg}{numeric vector that contains p-values for each season}
\item{Zg}{numeric vector that contains z-quantiles for each season}
}
\description{
Performs a Seasonal Mann-Kendall Trend Test (Hirsch-Slack Test)
}
\details{
The Mann-Kendall statistic for the $g$-th season is calculated as:

\deqn{
S_g = \sum_{i = 1}^{n-1} \sum_{j = i + 1}^n
\mathrm{sgn}\left(x_{jg} - x_{ig}\right), \qquad (1 \le g \le m)}

with \eqn{\mathrm{sgn}}{sgn} the signum function (see \code{\link{sign}}).

The mean of \eqn{S_g} is \eqn{\mu_g = 0}. The variance including the
correction term for ties is

\deqn{
\sigma_g^2 = \left\{n \left(n-1\right)\left(2n+5\right) -
\sum_{j=1}^p t_{jg}\left(t_{jg} - 1\right)\left(2t_{jg}+5\right) \right\} / 18
~~ (1 \le g \le m)}

The seasonal Mann-Kendall statistic for the entire series is calculated
according to

\deqn{
\begin{array}{ll}
\hat{S} = \sum_{g = 1}^m S_g &
\hat{\sigma}_g^2 =  \sum_{g = 1}^m \sigma_g^2
\end{array}}

The statistic \eqn{S_g} is approximately normally distributed, with

\deqn{z_g = S_g / \sigma_g} 

If \code{continuity = TRUE} then a continuity correction will be employed:

\deqn{z = \mathrm{sgn}(S_g) ~ \left(|S_g| - 1\right) / \sigma_g}
}
\examples{
res <- smk.test(nottem)
## print method
res
## summary method
summary(res)

}
\references{
Hipel, K.W. and McLeod, A.I. (2005),
\emph{Time Series Modelling of Water Resources and Environmental Systems}.
Electronic reprint of our book orginally published in 1994.
\url{http://www.stats.uwo.ca/faculty/aim/1994Book/}.

Libiseller, C. and Grimvall, A. (2002), Performance of partial
Mann-Kendall tests for trend detection in the presence of covariates.
\emph{Environmetrics} 13, 71--84, \url{http://dx.doi.org/10.1002/env.507}.

R. Hirsch, J. Slack, R. Smith (1982), Techniques of Trend Analysis for
Monthly Water Quality Data, \emph{Water Resources Research} 18, 107--121.
}
\concept{
Hirsch-Slack-Test
}
\keyword{nonparametric}
\keyword{ts}
\keyword{univar}
