% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language_field_id_for_name}
\alias{language_field_id_for_name}
\title{Language field identifiers}
\usage{
language_field_id_for_name(x, name)
}
\arguments{
\item{x}{\verb{[tree_sitter_language]}

A tree-sitter language object.}

\item{name}{\verb{[character]}

The language field names to look up field identifiers for.}
}
\value{
An integer vector the same length as \code{name} containing:
\itemize{
\item The field identifier for the field name, if known.
\item \code{NA}, if the field name was not known.
}
}
\description{
Get the integer field identifier for a field name. If you are going to be
using a field name repeatedly, it is often a little faster to use the
corresponding field identifier instead.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
language_field_id_for_name(language, "lhs")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=language_field_name_for_id]{language_field_name_for_id()}}
}
