% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point.R
\name{points}
\alias{points}
\alias{point}
\alias{point_row}
\alias{point_column}
\alias{is_point}
\title{Points}
\usage{
point(row, column)

point_row(x)

point_column(x)

is_point(x)
}
\arguments{
\item{row}{\verb{[double(1)]}

A 0-indexed row to place the point at.}

\item{column}{\verb{[double(1)]}

A 0-indexed column to place the point at.}

\item{x}{\verb{[tree_sitter_point]}

A point.}
}
\value{
\itemize{
\item \code{point()} returns a new point.
\item \code{point_row()} and \code{point_column()} return a single double.
\item \code{is_point()} returns \code{TRUE} or \code{FALSE}.
}
}
\description{
\itemize{
\item \code{point()} creates a new tree-sitter point.
\item \code{point_row()} and \code{point_column()} access a point's row and column value,
respectively.
\item \code{is_point()} determines whether or not an object is a point.
}

Note that points are 0-indexed. This is typically the easiest form to work
with them in, since most of the time when you are provided row and column
information from third party libraries, they will already be 0-indexed. It
is also consistent with bytes, which are also 0-indexed and are often
provided alongside their corresponding points.
}
\examples{
x <- point(1, 2)

point_row(x)
point_column(x)

is_point(x)
}
