% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parser-adjustments}
\alias{parser-adjustments}
\alias{parser_set_language}
\alias{parser_set_timeout}
\alias{parser_set_included_ranges}
\title{Parser adjustments}
\usage{
parser_set_language(x, language)

parser_set_timeout(x, timeout)

parser_set_included_ranges(x, included_ranges)
}
\arguments{
\item{x}{\verb{[tree_sitter_parser]}

A parser.}

\item{language}{\verb{[tree_sitter_language]}

A language.}

\item{timeout}{\verb{[double(1)]}

A single whole number corresponding to a timeout in microseconds to use
when parsing.}

\item{included_ranges}{\verb{[list_of<tree_sitter_range>]}

A list of ranges constructed by \code{\link[=range]{range()}}. These are the only locations
that will be considered when parsing.

An empty list can be used to clear any existing ranges so that the parser
will again parse the entire document.}
}
\value{
A new parser.
}
\description{
\itemize{
\item \code{parser_set_language()} sets the language of the parser. This is usually
done by \code{\link[=parser]{parser()}} though.
\item \code{parser_set_timeout()} sets an optional timeout used when calling
\code{\link[=parser_parse]{parser_parse()}} or \code{\link[=parser_reparse]{parser_reparse()}}. If the timeout is hit, an error
occurs.
\item \code{parser_set_included_ranges()} sets an optional list of ranges that are
the only locations considered when parsing. The ranges are created by
\code{\link[=range]{range()}}.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)
parser_set_timeout(parser, 10000)
\dontshow{\}) # examplesIf}
}
