% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-descendant}
\alias{node-descendant}
\alias{node_descendant_for_byte_range}
\alias{node_named_descendant_for_byte_range}
\alias{node_descendant_for_point_range}
\alias{node_named_descendant_for_point_range}
\title{Node descendants}
\usage{
node_descendant_for_byte_range(x, start, end)

node_named_descendant_for_byte_range(x, start, end)

node_descendant_for_point_range(x, start, end)

node_named_descendant_for_point_range(x, start, end)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}

\item{start, end}{\verb{[integer(1) / tree_sitter_point]}

For the byte range functions, start and end bytes to search within.

For the point range functions, start and end points created by \code{\link[=point]{point()}} to
search within.}
}
\value{
A node.
}
\description{
These functions return the smallest node within this node that spans the
given range of bytes or points. If the ranges are out of bounds, or no
smaller node can be determined, the input is returned.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# The whole `<-` binary operator node
node <- node_child(node, 1)
node

# The byte range points to a location in the word `function`
node_descendant_for_byte_range(node, 7, 9)
node_named_descendant_for_byte_range(node, 7, 9)

start <- point(0, 14)
end <- point(0, 15)

node_descendant_for_point_range(node, start, end)
node_named_descendant_for_point_range(node, start, end)

# OOB returns the input
node_descendant_for_byte_range(node, 25, 29)
\dontshow{\}) # examplesIf}
}
