% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_methods.R
\name{checkNdlst}
\alias{checkNdlst}
\title{Check if ndlst is correct}
\usage{
checkNdlst(ndlst, root)
}
\arguments{
\item{ndlst}{\code{ndlst}}

\item{root}{root ID}
}
\description{
Return T/F fpr \code{ndlst} consistency
}
\details{
Tests whether each node in tree points to valid other node IDs. Also
ensures `spn` and `root` are correct. Reports nodes that have errors.
}
\examples{
library(treeman)
tree <- randTree(100)
(checkNdlst(tree@ndlst, tree@root))
}
\seealso{
\code{\link{fastCheckTreeMan}}, \code{\link{checkTreeMen}}
}
