% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treefit.R
\name{treefit}
\alias{treefit}
\title{Estimate the goodness-of-fit between tree models and data}
\usage{
treefit(
  target,
  name = NULL,
  perturbations = NULL,
  normalize = NULL,
  reduce_dimension = NULL,
  build_tree = NULL,
  max_p = 20,
  n_perturbations = 20
)
}
\arguments{
\item{target}{The target data to be estimated. It must be one of them:
\itemize{
\item \code{list(counts=COUNTS, expression=EXPRESSION)}: You must specify
at least one of \code{COUNTS} and \code{EXPRESSION}.  They are
\code{matrix}. The rows and columns correspond to samples such as
cells and features such as genes. \code{COUNTS}'s value is count
data such as the number of genes expressed.  \code{EXPRESSION}'s
value is normalized count data.
\item \code{Seurat} object
}}

\item{name}{The name of \code{target} as string.}

\item{perturbations}{How to perturbate the target data.

If this is \code{NULL}, all available perturbation methods are used.

You can specify used perturbation methods as \code{list}. Here are
available methods:}

\item{normalize}{How to normalize counts data.

If this is \code{NULL}, the default normalization is applied.

You can specify a function that normalizes counts data.}

\item{reduce_dimension}{How to reduce dimension of expression data.

If this is \code{NULL}, the default dimensionality reduction is applied.

You can specify a function that reduces dimension of expression data.}

\item{build_tree}{How to build a tree of expression data.

If this is \code{NULL}, MST is built.

You can specify a function that builds tree of expression data.}

\item{max_p}{How many low dimension Laplacian eigenvectors are used.

The default is 20.}

\item{n_perturbations}{How many times to perturb.

The default is 20.}
}
\value{
An estimated result as a \code{treefit} object. It has the
following attributes:
\itemize{
\item \code{max_cca_distance}: The result of max canonical correlation
analysis distance as \code{data.frame}.
\item \code{rms_cca_distance}: The result of root mean square canonical
correlation analysis distance as \code{data.frame}.
\item \code{n_principal_paths_candidates}: The candidates of the number of
principal paths.
}

\code{data.frame} of \code{max_cca_distance} and \code{rms_cca_distance} has the
same structure. They have the following columns:
\itemize{
\item \code{p}: Dimensionality of the feature space of tree structures.
\item \code{mean}: The mean of the target distance values.
\item \code{standard_deviation}: The standard deviation of the target
distance values.
}
}
\description{
Estimate the goodness-of-fit between tree models and
data.
}
\examples{
# Generate a star tree data that have normalized expression values
# not count data.
star <- treefit::generate_2d_n_arms_star_data(300, 3, 0.1)
# Estimate tree-likeness of the tree data.
fit <- treefit::treefit(list(expression=star))

}
