% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate_2d_n_arms_star_data}
\alias{generate_2d_n_arms_star_data}
\title{Generate a 2-dimensional star tree data}
\usage{
generate_2d_n_arms_star_data(n_samples, n_arms, fatness)
}
\arguments{
\item{n_samples}{The number of samples to be generated.}

\item{n_arms}{The number of arms to be generated.}

\item{fatness}{How fat from the based star tree. \verb{[0.0, 1.0]} is
available value range.}
}
\value{
A generated \code{martix}. The rows and columns correspond to
samples and features.
}
\description{
Generate a 2-dimensional star tree data that contain
\code{n_samples} data points and fit a star tree with \code{n_arms} arms.
}
\examples{
# Generate a 2-dimensional star tree data that contain 500 data points
# and fit a star tree with 3 arms. The generated data are a bit noisy but
# tree-like.
star.tree_like <- treefit::generate_2d_n_arms_star_data(500, 3, 0.1)
plot(star.tree_like)

# Generate a 2-dimensional star tree data that contain 600 data points
# and fit a star tree with 5 arms. The generated data are very noisy and
# less tree-like.
star.less_tree_like <- treefit::generate_2d_n_arms_star_data(600, 5, 0.9)
plot(star.less_tree_like)

}
