% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiC2Tree.R
\name{HiCDOCDataSet}
\alias{HiCDOCDataSet}
\title{Create a HiCDOCDataSet object from a set of files}
\usage{
HiCDOCDataSet(files, format, binsize = NULL, chromosomes, index = NULL)
}
\arguments{
\item{files}{A character vector of file paths.}

\item{format}{A character vector of file formats corresponding to the files
in \code{file}. Supported formats are "tabular", "cooler", "juicer", and
  "HiC-Pro".}

\item{binsize}{An integer representing the bin size to use for cooler and
juicer formats. Ignored for tabular and HiC-Pro formats.}

\item{chromosomes}{A character vector specifying the chromosomes to include
in the output.}

\item{index}{A character vector of file paths to the index files required for
HiC-Pro format. Ignored for other formats.}
}
\value{
A list containing the following objects:
\describe{
  \item{HiCDOCDataSet}{A list of interaction matrices of the HiCDOCDataSet
  class of the HiCDOC package, one for each file}
  \item{indexData}{A data frame of index data for each interaction in the
  matrices.}
  \item{index_mat_chr}{A data frame containing the name of the matrices and
  the corresponding chromosome.}
}
}
\description{
This function creates a count matrix from a set of files
in different formats, such as tabular, cooler, juicer or HiC-Pro. It returns
a list of interaction matrices.
}
\examples{
\dontrun{
replicates <- 1:2
cond <- "90"
all_begins <- interaction(expand.grid(replicates, cond), sep = "-")
all_begins <- as.character(all_begins)

nb_chr <- 2
chromosomes <- 1:nb_chr
all_mat_chr <- lapply(chromosomes, function(chr) {
  all_mat <- lapply(all_begins, function(ab) {
    mat_file <- paste0("Rep", ab, "-chr", chr, "_200000.bed")
  })
  all_mat <- unlist(all_mat)
})
index <- system.file("extdata", "index.200000.longest18chr.abs.bed",
                     package = "treediff")
format <- rep("HiC-Pro", length(replicates) * length(cond) * nb_chr)
binsize <- 200000
files <- system.file("extdata", unlist(all_mat_chr), package = "treediff")
HiCDOCDataSet(files, format, binsize, chromosomes, index)
}

}
