% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_boundaries.R
\name{check_boundaries}
\alias{check_boundaries}
\title{Check Validity of Boundaries}
\usage{
check_boundaries(x, stop_on_error = TRUE, clean_data = FALSE)
}
\arguments{
\item{x}{A \code{\link{data.frame}} containing boundaries.
It has to have columns named by the contents of
either\cr
\code{\link{get_defaults}("boundaries")} or \cr
\code{fritools::get_options(package_name = "treePlotArea")[["boundaries"]]}.
\cr
Could be
\code{get(data("boundaries", package = "treePlotArea"))}.}

\item{stop_on_error}{Throw an error if invalid boundaries are found?}

\item{clean_data}{Get rid of invalid boundaries?}
}
\value{
A (possibly cleansed) \code{\link{data.frame}} containing boundaries.
}
\description{
There is a boundary (tract 6878, corner 1, boundary 1)in the federal database
for the 2012 survey that runs exactly through the plot. If that boundary
would be valid, at that corner the term "stand" is not defined.
}
\details{
So we check for such boundaries. These are straight boundaries with identical
azimuth values for start and end, and flexed boundaries where azimuth values
for either start or end and the azimuth value for the nook are identical and
the nook is farther away form the plot than the corresponding start or end.
}
\seealso{
Other boundary functions: 
\code{\link{get_boundary_polygons}()}
}
\concept{boundary functions}
