% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_filter_postcodes.R
\name{time_filter_postcodes}
\alias{time_filter_postcodes}
\title{Time Filter (Postcodes)}
\usage{
time_filter_postcodes(departure_searches = NULL, arrival_searches = NULL)
}
\arguments{
\item{departure_searches}{One or more objects created by \code{\link{make_search}}}

\item{arrival_searches}{One or more objects created by \code{\link{make_search}}}
}
\value{
API response parsed as a list and as a raw json
}
\description{
Find reachable postcodes from origin (or to destination) and get statistics about such postcodes.
Currently only supports United Kingdom.
}
\details{
See \url{https://docs.traveltime.com/api/reference/postcode-search/} for details
}
\examples{
\dontrun{
departure_search <-
 make_search(id = "public transport from Trafalgar Square",
             departure_time = strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ"),
             travel_time = 1800,
             coords = list(lat = 51.507609, lng = -0.128315),
             transportation = list(type = "public_transport"),
             properties = list('travel_time', 'distance'))

arrival_search <-
  make_search(id = "public transport to Trafalgar Square",
              arrival_time = strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ"),
              travel_time = 1800,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "public_transport"),
              properties = list('travel_time', 'distance'))

result <-
  time_filter_postcodes(
    departure_searches = departure_search,
    arrival_searches = arrival_search
  )
}
}
