% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{weights.transreg}
\alias{weights.transreg}
\title{Extract Weights}
\usage{
\method{weights}{transreg}(object, stack = NULL, ...)
}
\arguments{
\item{object}{object of class \code{transreg}}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}

\item{...}{(not applicable)}
}
\value{
Returns weights.
The output is a numerical vector
with one entry for each source of co-data.
}
\description{
Extracts weights from an object of class \link{transreg}.
}
\examples{
#--- simulation ---
set.seed(1)
n <- 100; p <- 500
X <- matrix(rnorm(n=n*p),nrow=n,ncol=p)
beta <- rnorm(p)
prior <- cbind(beta+rnorm(p),beta+rnorm(p),rnorm(p),rnorm(p))
y <- X \%*\% beta

#--- example ---
object <- transreg(y=y,X=X,prior=prior)
weights(object)

}
\references{
Armin Rauschenberger
\href{https://orcid.org/0000-0001-6498-4801}{\figure{orcid.png}{(iD)}},
Zied Landoulsi
\href{https://orcid.org/0000-0002-2327-3904}{\figure{orcid.png}{(iD)}},
Mark A. van de Wiel
\href{https://orcid.org/0000-0003-4780-8472}{\figure{orcid.png}{(iD)}},
and Enrico Glaab
\href{https://orcid.org/0000-0003-3977-7469}{\figure{orcid.png}{(iD)}}
(2022).
"Penalised regression with multiple sets of prior effects".
\emph{Manuscript in preparation.}
\doi{10.48550/arXiv.2212.08581}
\email{armin.rauschenberger@uni.lu}
}
\seealso{
This function is about weights for sources of prior effects.
To extract weights for features (estimated regression coefficients),
use \code{\link[=coef]{coef()}}.
}
