% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_locale.R
\name{trans_locale}
\alias{trans_locale}
\title{Access translation locale}
\usage{
trans_locale(locale)
}
\arguments{
\item{locale}{\code{character(1)}\cr
Locale to set, must be of form \code{"lang_country.encoding"} (or simplified
ones, i.e. \code{"lang_country"} and \code{"lang"}). \code{lang} and \code{country} must be
two-letter codes, preferably in agreement with the latest ISO norm.}
}
\value{
If \code{locale} was not passed, currently set locale, else nothing.
}
\description{
This function allows setting translation locale and accessing
the currently set one.
}
\examples{
trans_path(system.file("examples", package = "translated"))

# Check your default locale
trans_locale()

# Switch the translation to Polish language
trans_locale("pl_PL")
trans("title")

}
