% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.transfR}
\title{Plot transfR object}
\usage{
\method{plot}{transfR}(
  x,
  y,
  i,
  attribute,
  main = sprintf("Catchment \%i", i),
  xlab,
  ylab,
  format,
  at,
  nticks = 5,
  type = "l",
  lwd = 2,
  las = 1,
  cex.names = 1,
  col = c("#045a8d", "#fb8072", "#bebada", "#ffffb3", "#8dd3c7"),
  keeplocal = TRUE,
  ...
)
}
\arguments{
\item{x}{transfR object}

\item{y}{ignored}

\item{i}{spatial index to plot}

\item{attribute}{attribute of the transfR object to plot}

\item{main}{a main title for the plot, see also \link[graphics]{title}}

\item{xlab}{a label for the x axis, defaults to a description of x}

\item{ylab}{a label for the y axis, defaults to a description of y}

\item{format}{format for labels of time series on x axis}

\item{at}{a date-time or date object for ticks on x axis}

\item{nticks}{number of ticks on x axis}

\item{type}{1-character string giving the type of plot desired (for details,
see \link[graphics]{plot})}

\item{lwd}{the line width (for details, see \link[graphics]{par})}

\item{las}{the style of axis labels (for details, see \link[graphics]{par})}

\item{cex.names}{expansion factor for axis names (for details, see \link[graphics]{barplot})}

\item{col}{a specification for the default plotting color (for details, see \link[graphics]{par})}

\item{keeplocal}{boolean to preserve local graphical parameters}

\item{...}{further specifications, see \link[graphics]{plot}}
}
\description{
Plot transfR object.
}
\examples{
data(Oudon)
object <- as_transfr(st=Oudon$obs,hl=Oudon$hl)
plot(object,attribute="Qobs")
}
