% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.R
\name{implemented_model_classes}
\alias{implemented_model_classes}
\alias{BoxCoxICP}
\alias{SurvregICP}
\alias{survregICP}
\alias{coxphICP}
\alias{ColrICP}
\alias{CoxphICP}
\alias{LehmannICP}
\alias{LmICP}
\alias{lmICP}
\alias{PolrICP}
\alias{polrICP}
\alias{glmICP}
\alias{cotramICP}
\alias{rangerICP}
\alias{survforestICP}
\alias{qrfICP}
\title{Aliases for implemented model classes}
\usage{
BoxCoxICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

SurvregICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

survregICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

coxphICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

ColrICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

CoxphICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

LehmannICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

LmICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

lmICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

PolrICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

polrICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

glmICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

cotramICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

rangerICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

survforestICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)

qrfICP(
  formula,
  data,
  env,
  verbose = TRUE,
  type = "residual",
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} including response and covariate terms.}

\item{data}{A \code{data.frame} containing response and explanatory variables.}

\item{env}{A \code{formula} specifying the environment variables (see details).}

\item{verbose}{Logical, whether output should be verbose (default \code{TRUE}).}

\item{type}{Character, type of invariance (\code{"residual"} or \code{"wald"});
see \code{Details}.}

\item{test}{Character, specifies the invariance test to be used when
\code{type = "residual"}. The default is \code{"gcm.test"}. Other
implemented tests are \code{"HSIC"}, \code{"t.test"}, \code{"var.test"},
and \code{"combined"}. Alternatively, a custom function for testing
invariance of the form \code{\(r, e, controls) {...}} can be supplied,
which outputs a list with entry \code{"p.value"}.}

\item{controls}{Controls for the used tests and the overall procedure,
see \code{\link{dicp_controls}}.}

\item{alpha}{Level of invariance test, default \code{0.05}.}

\item{baseline_fixed}{Fixed baseline transformation, see
\code{\link[tramicp]{dicp_controls}}.}

\item{greedy}{Logical, whether to perform a greedy version of ICP (default is
\code{FALSE}).}

\item{max_size}{Numeric; maximum support size.}

\item{mandatory}{A \code{formula} containing mandatory covariates, i.e.,
covariates which by domain knowledge are believed to be parents
of the response or are in another way required for the environment or
model to be valid (for instance, conditionally valid environments or
random effects in a mixed model).}

\item{...}{Further arguments passed to \code{modFUN}.}
}
\value{
Object of type \code{"dICP"}. See \code{\link[tramicp]{dicp}}
}
\description{
ICP for Box-Cox-type transformed normal regression, parametric
    and semiparametric survival models, continuous outcome logistic
    regression, linear regression, cumulative ordered regression, generalized
    linear models; and nonparametric ICP via ranger. While TRAMICP based on
    quantile and survival random forests is also supported, for these methods
    it comes without theoretical guarantees as of yet.
}
\examples{
set.seed(123)
d <- dgp_dicp(mod = "boxcox", n = 300)
BoxCoxICP(Y ~ X2, data = d, env = ~ E, type = "wald")

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "weibull", n = 300)
SurvregICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
### or
library("survival")
d$Y <- Surv(d$Y)
survregICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
CoxphICP(Y ~ X2, data = d, env = ~ E)
coxphICP(Y ~ X2, data = d, env = ~ E)
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "colr", n = 300)
ColrICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "coxph", n = 300)
LehmannICP(Y ~ X2, data = d, env = ~ E)
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "lm", n = 300)
LmICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
### or
lmICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "polr", n = 300)
PolrICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
### or
PolrICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "binary", n = 300)
glmICP(Y ~ X1 + X2 + X3, data = d, env = ~ E, family = "binomial")
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "cotram", n = 300)
cotramICP(Y ~ X2, data = d, env = ~ E)
}

\donttest{
set.seed(123)
d <- dgp_dicp(mod = "binary", n = 300)
rangerICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
}

\donttest{
set.seed(12)
d <- dgp_dicp(mod = "coxph", n = 3e2)
d$Y <- survival::Surv(d$Y, sample(0:1, 3e2, TRUE, prob = c(0.1, 0.9)))
survforestICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
}

\donttest{
set.seed(12)
d <- dgp_dicp(mod = "boxcox", n = 3e2)
qrfICP(Y ~ X1 + X2 + X3, data = d, env = ~ E)
}

}
