% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{coef.LmME}
\alias{coef.LmME}
\title{Extract the coefficients of the fixed effects terms of an LmME model.}
\usage{
\method{coef}{LmME}(object, as.lm = FALSE, fixed = TRUE, ...)
}
\arguments{
\item{object}{An \code{LmME} object.}

\item{as.lm}{If \code{TRUE}, return the transformed coefficients as in a
\code{lmerMod} object.}

\item{fixed}{If \code{TRUE}, also include the fixed parameters.}

\item{...}{Optional arguments passed to \code{coef.tramME}.}
}
\value{
A numeric vector of the transformed coefficients.
}
\description{
Extract the coefficients of the fixed effects terms of an LmME model.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
coef(fit, as.lm = TRUE)
}
