% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{varcov<-.tramME}
\alias{varcov<-.tramME}
\title{Set the values of the random effects covariance matrices of a tramME model.}
\usage{
\method{varcov}{tramME}(object) <- value
}
\arguments{
\item{object}{A tramME object (fitted or unfitted).}

\item{value}{A list of positive definite covariance matrices.}
}
\value{
An unfitted tramME object with the new coefficient values.
}
\description{
Sets the list containing the covariance matrices of a tramME model. The matrices have
to be positive definite. Just as in \code{"coef<-"}, when the function is called
on a fitted object, it will be set to unfitted.
}
\details{
The supplied list does not have to be named, and the names will be ignored.
When multiple grouping factors are present, the function assumes the same order as in the
object to be modified. Hence, it might be a good idea to call \code{varcov} first, and
modify this list to make sure that the input has the right structure.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
vc <- varcov(mod)
vc[[1]] <- matrix(c(1, 0, 0, 2), ncol = 2)
varcov(mod) <- vc
}
