% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo.R
\name{trafo.tramME}
\alias{trafo.tramME}
\title{Get the baseline transformation function and its confidence
interval}
\usage{
\method{trafo}{tramME}(object, newdata = NULL, type = c("trafo",
  "distribution", "survivor", "cumhazard"), confidence = c("none",
  "interval", "band", "asymptotic"), level = 0.95, K = 50, ...)
}
\arguments{
\item{object}{A fitted tramME object.}

\item{newdata}{Values of the interacting terms to be used.}

\item{type}{The scale on which the transformation function is evaluated.}

\item{confidence}{Pointwise confidence interval or confidence band.}

\item{level}{Confidence level.}

\item{K}{Integer, number of points in the grid the function is
evaluated on.}

\item{...}{Additional parameters (for consistency with generic)}
}
\value{
Matrix or list of matrices containing the point estimates and the
  confidence intervals.
}
\description{
For stratified models, it returns a list of data frames for each
stratum.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
tr <- trafo(fit, type = "distribution", confidence = "interval", K = 100)
}
