% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{TrajsStepLengths}
\alias{TrajsStepLengths}
\title{Step lengths of multiple trajectories}
\usage{
TrajsStepLengths(trjs)
}
\arguments{
\item{trjs}{A list of \code{Trajectory} objects.}
}
\value{
A numeric vector containing the lengths of every step in every trajectory.
}
\description{
Returns the lengths of all of the steps in a list of trajectories
}
\examples{
\dontrun{
trjs <- TrajsBuild(fileNames, scale = scale, units = "m")
# Print a summary about the step sizes across all trajectories
print(summary(TrajsStepLengths(trjs)))
}

}
