% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_zanne.R
\name{tr_zanne}
\alias{tr_zanne}
\title{Zanne et al. plant dataset}
\usage{
tr_zanne(read = TRUE, ...)
}
\arguments{
\item{read}{(logical) read in csv files. Default: \code{TRUE}}

\item{...}{Curl options passed on to [crul::HttpClient()]}
}
\value{
paths to the files (character) if \code{read=FALSE} or
a list of data.frame's if \code{read=TRUE}
}
\description{
Zanne et al. plant dataset
}
\details{
This data is a dataset stored on Dryad (doi: 10.5061/dryad.63q27).
When using this data, cite the paper:

Zanne AE, Tank DC, Cornwell WK, Eastman JM, Smith SA, FitzJohn RG,
McGlinn DJ, O'Meara BC, Moles AT, Reich PB, Royer DL, Soltis DE, Stevens PF,
Westoby M, Wright IJ, Aarssen L, Bertin RI, Calaminus A, Govaerts R,
Hemmings F, Leishman MR, Oleksyn J, Soltis PS, Swenson NG, Warman L,
Beaulieu JM, Ordonez A (2014) Three keys to the radiation of angiosperms
into freezing environments. Nature 506(7486): 89-92.
http://dx.doi.org/10.1038/nature12872

As well as the Dryad data package:

Zanne AE, Tank DC, Cornwell WK, Eastman JM, Smith SA, FitzJohn RG,
McGlinn DJ, O'Meara BC, Moles AT, Reich PB, Royer DL, Soltis DE, Stevens PF,
Westoby M, Wright IJ, Aarssen L, Bertin RI, Calaminus A, Govaerts R,
Hemmings F, Leishman MR, Oleksyn J, Soltis PS, Swenson NG, Warman L,
Beaulieu JM, Ordonez A (2013) Data from: Three keys to the radiation of
angiosperms into freezing environments. Dryad Digital Repository.
http://dx.doi.org/10.5061/dryad.63q27.2
}
\examples{
\dontrun{
res <- tr_zanne()
res$tax_lookup
res$woodiness
res$freezing
res$leaf_phenology
}
}
\references{
http://datadryad.org/resource/doi:10.5061/dryad.63q27
}
