% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{arthropodtraits}
\alias{arthropodtraits}
\title{Functional Arthropod Traits}
\format{
A data frame of 1230 observations and 17 variables.
\describe{
\item{Order}{}
\item{Suborder}{}
\item{Family}{}
\item{SpeciesID}{}
\item{Author}{}
\item{Body_Size}{Mean body length (mm)}
\item{Dispersal_ability}{ordinal scale of 0 = very low, 1 = low, 0,5 =
medium, 0,75 = high, 1 = very high; Based on wing dimorphism, flying
ability, activity ranges, dispersal strategies, individual movement and
colonization dynamics, depending on taxon }
\item{Feeding_guild}{Fine classification of feeding guild across larval and
adult stages; less frequent assignments in brackets.
\describe{
\item{c}{carnivore}
\item{c-d}{carni-detritivore}
\item{c-d-h}{carni-detriti-herbivore}
\item{c-f}{carni-fungivore}
\item{c-h}{carni-herbivore}
\item{c-(h)}{mainly carnivore, rarely herbivore}
\item{d}{detritivor}
\item{d-f}{detriti-fungivore}
\item{d-h}{detriti-herbivore}
\item{f}{fungivore}
\item{f-h}{fungi-herbivore}
\item{h}{herbivor}
\item{h-(c)}{mainly herbivore, rarely carnivore}
}
}
\item{Feeding_guild_short}{Coarse classification of feeding guild, indicating main feeding source across larval and adult stages}
\item{Feeding_mode}{The way nutrients are ingested}
\item{Feeding_specialization}{Host plant specialization in herbivores}
\item{Feeding_tissue}{Fine classification on the plant tissues sucking herbivores are feeding on}
\item{Feeding_plant_part}{Fine classification on the plant parts chewing herbivores are feeding on}
\item{Endophagous_lifestyle}{Details on endophagously living larvae}
\item{Stratum_use}{Vertical strata used across larval and adult stages; less frequent assignments in brackets}
\item{Stratum_use_short}{Main vertical stratum used across larval and adult stages}
\item{Remark}{Indicates species that do neither obligatory nor facultative occur in grasslands; * = non grasland species}

}

original description: https://www.nature.com/articles/sdata201513/tables/3
}
\source{
\doi{10.5061/dryad.53ds2};
\href{https://creativecommons.org/publicdomain/zero/1.0/}{Creative Commons
0}. To the extent possible under law, the authors have waived all copyright
and related or neighboring rights to this data.
}
\value{
This is a data object. provides instructions for \code{pulldata()}.
}
\description{
Data from: A summary of eight traits of Coleoptera, Hemiptera, Orthoptera and
Araneae, occurring in grasslands in Germany.
}
\details{
Analyses of species traits have increased our understanding of how
environmental drivers such as disturbances affect the composition of
arthropod communities and related processes. There are, however, few
studies on which traits in the arthropod community are affected by
environmental changes and which traits affect ecosystem functioning. The
assembly of arthropod traits of several taxa is difficult because of the
large number of species, limited availability of trait databases and
differences in available traits. We sampled arthropod species data from a
total of 150 managed grassland plots in three regions of Germany. These
plots represent the spectrum from extensively used pastures to mown
pastures to intensively managed and fertilized meadows. In this paper, we
summarize information on body size, dispersal ability, feeding guild and
specialization (within herbivores), feeding mode, feeding tissue (within
herbivorous suckers), plant part (within herbivorous chewers), endophagous
lifestyle (within herbivores), and vertical stratum use for 1,230 species
of Coleoptera, Hemiptera (Heteroptera, Auchenorrhyncha), Orthoptera
(Saltatoria: Ensifera, Caelifera), and Araneae, sampled by sweep-netting
between 2008 and 2012. We compiled traits from various literature sources
and complemented data from reliable internet sources and the authors’
experience.

The data set comprises literature trait data of species that were sampled
and measured in a project within the Biodiversity Exploratories which
focuses on the effect of land use on arthropod community composition and
related processes (e.g. species interactions such as herbivory or
predation) in three regions of Germany

When using this data, please cite the original publication:

\itemize{ \item  Gossner MM, Simons NK, Achtziger R, Blick T, Dorow WHO,
Dziock F, Köhler F, Rabitsch W, Weisser WW (2015) A summary of eight traits
of Coleoptera, Hemiptera, Orthoptera and Araneae, occurring in grasslands
in Germany. Scientific Data 2: 150013.
\doi{10.1038/sdata.2015.13} }

Additionally, please cite the Dryad data package:

\itemize{ \item  Gossner MM, Simons NK, Achtziger R,
Blick T, Dorow WHO, Dziock F, Köhler F, Rabitsch W, Weisser WW (2015) Data
from: A summary of eight traits of Coleoptera, Hemiptera, Orthoptera and
Araneae, occurring in grasslands in Germany. Dryad Digital Repository.
\doi{10.5061/dryad.53ds2} }
}
\seealso{
Other rawdata: 
\code{\link{amniota}},
\code{\link{amphibio}},
\code{\link{carabids}},
\code{\link{heteroptera_raw}},
\code{\link{mammaldiet}},
\code{\link{pantheria}},
\code{\link{pulldata}()}
}
\author{
Gossner MM, Simons NK, Achtziger R, Blick T, Dorow WHO, Dziock F, Köhler F, Rabitsch W, Weisser WW
}
\concept{rawdata}
