% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.traitdata.R
\name{cast.traitdata}
\alias{cast.traitdata}
\title{Cast long-table trait data into wide-table format}
\usage{
cast.traitdata(.data, values = "traitValue", traits = "traitName",
  units = "traitUnit", fun.aggregate = NULL)
}
\arguments{
\item{.data}{dataset of class 'traitdata' to be cast into wide-table format.}

\item{values}{the column name containing the trait values to be used to fill
the matrix (default is \code{traitValue}). Duplicate columns (e.g.
\code{traitValueStd}) will be omitted. See notes.}

\item{traits}{the column name to be kept for parsing into wide-table (default
is \code{traitName}). Note that any duplicate column that contains trait names,
e.g. \code{traitNameStd} will be omitted.}

\item{units}{the column name containing the units of numerical values
(default is \code{traitUnit}).}

\item{fun.aggregate}{option for \code{\link[reshape2:cast]{reshape2::cast()}} to define method of
aggregation.}
}
\value{
a wide-table data.frame object containing all taxa (and other
differentiating parameters) in rows and all traits (extracted from column
'traitName') in columns.
}
\description{
Function to reformat trait data from the long-table into a matrix/wide-table
or occurrence table format.
}
\details{
The wide-table will be composed while preserving the detail given in
the dataset (occurrence level or taxa level). The cells  will be filled
with the values from 'traitValue'.

If taxa should be summarized, provide function for summarizing in parameter
'summarize'. This can be any function that takes a vector and returns a
single value for \strong{both numerical and factorial/character input vectors!}.
The default for numerical values is to return an arithmetric mean while
including any outliers. For factorial values, the value is accepted if it
is equal in all of the input entries. Otherwise NA is returned. For
heterogeneous factorial or character input, user action is required for
homogenizing the data before calling \code{cast.traitdata()}.
}
\section{Duplicate columns}{
 The function is currently not able to handle
multiple columns of trait data (incl. names and units). Those are currently
omitted from the output and may be added manually. You can alter the
columns to be used to construct the matrix by specifying those in
parameters \code{traits}, \code{values}, and \code{units}. Automatic handling of the \code{Std}
columns might be added at a later stage.
}

\examples{

pulldata("arthropodtraits")
head(arthropodtraits)
dataset3 <- as.traitdata(arthropodtraits,
                         taxa = "SpeciesID",
                         traits = c("Body_Size", "Dispersal_ability",
                               "Feeding_guild","Feeding_guild_short",
                               "Feeding_mode", "Feeding_specialization",
                               "Feeding_tissue", "Feeding_plant_part",
                               "Endophagous_lifestyle", "Stratum_use",
                               "Stratum_use_short"),
                         units = c(Body_Size = "mm"),
                         keep = c(measurementRemark = "Remark"),
                         metadata = as.metadata(
                            license = "http://creativecommons.org/publicdomain/zero/1.0/"
                            )
)

head(dataset3)

dd3 <-cast.traitdata(dataset3)
head(dd3)


}
