% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim.R
\name{estim_lme}
\alias{estim_lme}
\title{Wrapper function for estimation methods - linear mixed models}
\usage{
estim_lme(lambda, y, formula, data, rand_eff, method, trafo, custom_func,
  custom_func_std)
}
\arguments{
\item{lambda}{transformation parameter}

\item{y}{vector of response variables}

\item{formula}{a formula object that contains the dependent and the explanatory
measures}

\item{data}{the data.frame that is given to function nlme and that contains the 
regression variables.}

\item{rand_eff}{the random effect extracted from the lme object.}

\item{method}{a character string. In order to determine the optimal parameter
for the transformation five different estimation methods can be chosen
(i) Maximum-Likelihood ("ml"); (ii) skewness minimization ("skew");
(iii) minimization of Kolmogorov-Smirnov divergence  ("div.ks");
(iv) minimization of Cramer von Mises divergence ("div.cvm"); (v)
minimization of Kullback Leibler divergence  ("div.kl"). In case of no and
log transformation "NA" can be selected since no optimization is necessary
for these two transformation types.}

\item{trafo}{a character string that selects the transformation.}

\item{custom_func}{a function that determines a customized transformation.}

\item{custom_func_std}{a function that determines a customized standard
transformation.}
}
\value{
Depending on the selected \code{method} the return is a log
likelihood, a skewness, a pooled skewness or a Kolmogorov-Smirnov, Cramer
von Mises or Kullback Leibler divergence.
}
\description{
Wrapper function for estimation methods - linear mixed models
}
\keyword{internal}
