% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{identifyImageFileNames}
\alias{identifyImageFileNames}
\alias{imageFileExists}
\alias{removeImageFiles}
\alias{symlinkImageFiles}
\alias{copyImageFiles}
\alias{readImageFile}
\alias{writeImageFile}
\title{Working with MRI images stored in various formats}
\usage{
identifyImageFileNames(fileName, fileType = NULL, errorIfMissing = TRUE,
  auxiliaries = c("dirs", "lut", "tags"), ...)

imageFileExists(fileName, fileType = NULL)

removeImageFiles(fileName, ...)

symlinkImageFiles(from, to, overwrite = FALSE, relative = TRUE, ...)

copyImageFiles(from, to, overwrite = FALSE, deleteOriginals = FALSE, ...)

readImageFile(fileName, fileType = NULL, metadataOnly = FALSE,
  volumes = NULL, sparse = FALSE, mask = NULL, reorder = TRUE, ...)

writeImageFile(image, fileName = NULL, fileType = NA, overwrite = TRUE,
  datatype = "fit", writeTags = FALSE)
}
\arguments{
\item{fileName, from, to}{File names, with or without appropriate extension.}

\item{fileType}{A character vector of length one, giving the file type
required or expected. If this option is missing, the file type used for
writing images will be taken from the \code{tractorFileType} option. See
Details.}

\item{errorIfMissing}{Logical value: raise an error if no suitable files
were found?}

\item{auxiliaries}{A character vector of auxiliary file suffixes to search
for.}

\item{\dots}{For \code{identifyImageFileNames}, additional arguments to
\code{\link{resolvePath}}. Elsewhere, additional arguments to
\code{identifyImageFileNames}.}

\item{overwrite}{Logical value: overwrite an existing image file? For
\code{writeImageFile}, an error will be raised if there is an existing
file and this is set to FALSE.}

\item{relative}{Logical value: if \code{TRUE}, the path stored in the
symlink will be relative (e.g. \code{"../some_dir/some_image.nii"}) rather
than absolute (e.g. \code{"/path/to/some_dir/some_image.nii"}).}

\item{deleteOriginals}{Logical value: if \code{TRUE}, \code{copyImageFiles}
performs a move rather than a copy.}

\item{metadataOnly}{Logical value: if \code{TRUE}, only metadata are read
into the object.}

\item{volumes}{An optional integer vector specifying a subset of volumes to
read (generally to save memory). If given, only the requested volumes in
the 4D file will be read.}

\item{sparse}{Logical value: should the image data be stored in a
\code{\linkS4class{SparseArray}} object?}

\item{mask}{An optional \code{\linkS4class{MriImage}} object representing a
mask, outside of which the image to be read should be considered to be
zero. This can be used to save memory when only a small part of a large
image is of interest. Ignored if \code{sparse} is not \code{TRUE}.}

\item{reorder}{Logical value: should the image data be reordered to LAS?
This is recommended in most circumstances.}

\item{image}{An \code{\linkS4class{MriImage}} object.}

\item{datatype}{A datatype string, such as \code{"uint8"} or \code{"float"},
specifying the pixel datatype to use when storing the data. If specified,
this must be a type supported by the requested (or default) file format.
The default, \code{"fit"}, results in a datatype being chosen that is wide
enough to fit the range of the data elements. An error will arise if
there's no such type.}

\item{writeTags}{Logical value: should tags be written in YAML format to an
auxiliary file?}
}
\value{
\code{readImageFile} returns an \code{\linkS4class{MriImage}}
  object. \code{imageFileExists} returns \code{TRUE} if an existing file
  with the specified name exists (all file extensions are checked), and
  \code{FALSE} otherwise. \code{removeImageFiles} returns the result of
  \code{\link{unlink}} applied to all relevant files. \code{writeImageFile}
  and \code{identifyImageFileNames} return a list with the following elements,
  describing the identified or written files:
  \describe{
    \item{fileStem}{The file name without extension.}
    \item{headerFile}{The full header file name.}
    \item{imageFile}{The full image file name.}
    \item{format}{The format of the files (\code{"Nifti"}, \code{"Analyze"}
      or \code{"Mgh"}). Not returned by \code{writeImageFile}.}
  }
  \code{copyImageFiles} and \code{symlinkImageFiles} are called for their
  side effects.
}
\description{
Functions for reading, writing, locating, copying and removing MRI images
stored in NIfTI, Analyze, MGH and MRtrix formats.
}
\details{
NIfTI and Analyze are related formats for storing magnetic resonance images.
NIfTI is a more recent extension of Analyze, and contains more specific
information about, for example, the orientation of the image. Its use is
therefore recommended where possible. MGH format is used by the popular
image processing package FreeSurfer, and MRtrix format by the software of
the same name. These formats use a number of different file extensions, but
the details are abstracted away from the user by these functions.

TractoR does not allow for files with the same basic name using multiple
Analyze/NIfTI/MGH/MRtrix formats in a single directory (e.g.
\code{"foo.nii"} AND \code{"foo.img"}), and these functions will produce an
error if multiple compatible files exist.

Suitable values for \code{fileType} (and the \code{tractorFileType} option,
which is used as a default for writing) are \code{"NIFTI"},
\code{"NIFTI_PAIR"} (the two-file NIfTI format), \code{"MGH"}, and
corresponding gzipped versions of these with \code{"_GZ"} appended. File
types \code{"ANALYZE"} and \code{"MRTRIX"}, and \code{"_GZ"} variants, are
additionally available for reading only. \code{"NIFTI_GZ"} is the default
value for the \code{tractorFileType} option, but that can be changed using a
call to \code{\link{options}}, or by setting the \code{TRACTOR_FILETYPE}
environment variable before loading the \code{tractor.base} package.

Since multiple files may be involved, copying, moving or symlinking images
is not trivial. \code{copyImageFiles} and \code{symlinkImageFiles} are
wrappers around the standard functions \code{\link{file.copy}} and
\code{\link{file.symlink}} which handle this complexity.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
The NIfTI-1 standard (\url{http://nifti.nimh.nih.gov/nifti-1}) and
  \code{\linkS4class{MriImage}}.
}
\author{
Jon Clayden
}
