% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading.R
\name{readX}
\alias{readX}
\alias{readTCX}
\alias{readGPX}
\alias{readDB3}
\alias{readJSON}
\title{Read a training file in tcx, gpx, db3 or Golden Cheetah's JSON
format}
\usage{
readTCX(file, timezone = "", speedunit = "m_per_s",
  distanceunit = "m", ...)

readGPX(file, timezone = "", speedunit = "km_per_h",
  distanceunit = "km", ...)

readDB3(file, timezone = "", table = "gps_data",
  speedunit = "km_per_h", distanceunit = "km", ...)

readJSON(file, timezone = "", speedunit = "km_per_h",
  distanceunit = "km", ...)
}
\arguments{
\item{file}{The path to a tcx, gpx, json or db3 file. Compressed
versions (gz, bz2, xz, zip) of tcx, gpx, and json files are
directly supported.}

\item{timezone}{The timezone of the observations as passed on to
\code{\link[base]{as.POSIXct}}.  Ignored for JSON files.}

\item{speedunit}{Character string indicating the measurement unit
of the speeds in the container file to be converted into meters
per second. See Details.}

\item{distanceunit}{Character string indicating the measurement
unit of the distance in the container file to be converted into
meters. See Details.}

\item{...}{Currently not used.}

\item{table}{Character string indicating the name of the table with
the GPS data in the db3 container file.}
}
\description{
Read a training file in tcx, gpx, db3 or Golden Cheetah's JSON
format
}
\details{
Available options for \code{speedunit} currently are
\code{km_per_h}, \code{m_per_s}, \code{mi_per_h},
\code{ft_per_min} and \code{ft_per_s}. The default is
\code{m_per_s} for TCX files and \code{km_per_h} for db3 and
Golden Cheetah's json files.  Available options for
\code{distanceunit} currently are \code{km}, \code{m},
\code{mi} and \code{ft}. The default is \code{m} for TCX and
\code{km} for gpx, db3 and Golden Cheetah's json files.

\code{readTCX}, \code{readGPX}, \code{readGPX} and \code{readDB3},
try to identify the sport from the data in the container file. If
that fails, then an attempt is made to guess the sport from
keywords in the filename. If identification is not possible then
the \code{file} attribute of the returned object has value
\code{NA}.

Reading Golden Cheetah's JSON files is experimental.
}
\examples{
## read raw data
filepath <- system.file("extdata/tcx", "2013-06-08-090442.TCX.gz", package = "trackeR")
run0 <- readTCX(file = filepath, timezone = "GMT")

## turn into trackeRdata object
units0 <- generate_units()
run0 <- trackeRdata(run0, units = units0)

## alternatively
\dontrun{
run0 <- read_container(filepath, type = "tcx", timezone = "GMT")
}

}
